// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.GetOriginAccessControlConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetOriginAccessControlConfigOperationDeserializer: HttpDeserialize<GetOriginAccessControlConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetOriginAccessControlConfigResponse {
        if (!response.status.isSuccess()) {
            throwGetOriginAccessControlConfigError(context, response)
        }
        val builder = GetOriginAccessControlConfigResponse.Builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.originAccessControlConfig = deserializeOriginAccessControlConfigPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwGetOriginAccessControlConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "NoSuchOriginAccessControl" -> NoSuchOriginAccessControlDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
