// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.GetMonitoringSubscriptionResponse
import aws.sdk.kotlin.services.cloudfront.model.MonitoringSubscription
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetMonitoringSubscriptionOperationDeserializer: HttpDeserialize<GetMonitoringSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMonitoringSubscriptionResponse {
        if (!response.status.isSuccess()) {
            throwGetMonitoringSubscriptionError(context, response)
        }
        val builder = GetMonitoringSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.monitoringSubscription = deserializeMonitoringSubscriptionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwGetMonitoringSubscriptionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "NoSuchDistribution" -> NoSuchDistributionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchMonitoringSubscription" -> NoSuchMonitoringSubscriptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
