// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryption
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateFieldLevelEncryptionConfigOperationDeserializer: HttpDeserialize<CreateFieldLevelEncryptionConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateFieldLevelEncryptionConfigResponse {
        if (!response.status.isSuccess()) {
            throwCreateFieldLevelEncryptionConfigError(context, response)
        }
        val builder = CreateFieldLevelEncryptionConfigResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.fieldLevelEncryption = deserializeFieldLevelEncryptionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwCreateFieldLevelEncryptionConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FieldLevelEncryptionConfigAlreadyExists" -> FieldLevelEncryptionConfigAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "NoSuchFieldLevelEncryptionProfile" -> NoSuchFieldLevelEncryptionProfileDeserializer().deserialize(context, wrappedResponse)
        "QueryArgProfileEmpty" -> QueryArgProfileEmptyDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionConfigs" -> TooManyFieldLevelEncryptionConfigsDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionContentTypeProfiles" -> TooManyFieldLevelEncryptionContentTypeProfilesDeserializer().deserialize(context, wrappedResponse)
        "TooManyFieldLevelEncryptionQueryArgProfiles" -> TooManyFieldLevelEncryptionQueryArgProfilesDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
