// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Contains the result of testing a CloudFront function with `TestFunction`.
 */
public class TestResult private constructor(builder: Builder) {
    /**
     * The amount of time that the function took to run as a percentage of the maximum allowed time. For example, a compute utilization of 35 means that the function completed in 35% of the maximum allowed time.
     */
    public val computeUtilization: kotlin.String? = builder.computeUtilization
    /**
     * If the result of testing the function was an error, this field contains the error message.
     */
    public val functionErrorMessage: kotlin.String? = builder.functionErrorMessage
    /**
     * Contains the log lines that the function wrote (if any) when running the test.
     */
    public val functionExecutionLogs: List<String>? = builder.functionExecutionLogs
    /**
     * The event object returned by the function. For more information about the structure of the event object, see [Event object structure](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val functionOutput: kotlin.String? = builder.functionOutput
    /**
     * Contains configuration information and metadata about the CloudFront function that was tested.
     */
    public val functionSummary: aws.sdk.kotlin.services.cloudfront.model.FunctionSummary? = builder.functionSummary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.TestResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestResult(")
        append("computeUtilization=$computeUtilization,")
        append("functionErrorMessage=*** Sensitive Data Redacted ***,")
        append("functionExecutionLogs=*** Sensitive Data Redacted ***,")
        append("functionOutput=*** Sensitive Data Redacted ***,")
        append("functionSummary=$functionSummary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeUtilization?.hashCode() ?: 0
        result = 31 * result + (functionErrorMessage?.hashCode() ?: 0)
        result = 31 * result + (functionExecutionLogs?.hashCode() ?: 0)
        result = 31 * result + (functionOutput?.hashCode() ?: 0)
        result = 31 * result + (functionSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestResult

        if (computeUtilization != other.computeUtilization) return false
        if (functionErrorMessage != other.functionErrorMessage) return false
        if (functionExecutionLogs != other.functionExecutionLogs) return false
        if (functionOutput != other.functionOutput) return false
        if (functionSummary != other.functionSummary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.TestResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time that the function took to run as a percentage of the maximum allowed time. For example, a compute utilization of 35 means that the function completed in 35% of the maximum allowed time.
         */
        public var computeUtilization: kotlin.String? = null
        /**
         * If the result of testing the function was an error, this field contains the error message.
         */
        public var functionErrorMessage: kotlin.String? = null
        /**
         * Contains the log lines that the function wrote (if any) when running the test.
         */
        public var functionExecutionLogs: List<String>? = null
        /**
         * The event object returned by the function. For more information about the structure of the event object, see [Event object structure](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/functions-event-structure.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var functionOutput: kotlin.String? = null
        /**
         * Contains configuration information and metadata about the CloudFront function that was tested.
         */
        public var functionSummary: aws.sdk.kotlin.services.cloudfront.model.FunctionSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.TestResult) : this() {
            this.computeUtilization = x.computeUtilization
            this.functionErrorMessage = x.functionErrorMessage
            this.functionExecutionLogs = x.functionExecutionLogs
            this.functionOutput = x.functionOutput
            this.functionSummary = x.functionSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.TestResult = TestResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionSummary] inside the given [block]
         */
        public fun functionSummary(block: aws.sdk.kotlin.services.cloudfront.model.FunctionSummary.Builder.() -> kotlin.Unit) {
            this.functionSummary = aws.sdk.kotlin.services.cloudfront.model.FunctionSummary.invoke(block)
        }
    }
}
