// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



public class TestFunctionRequest private constructor(builder: Builder) {
    /**
     * The event object to test the function with. For more information about the structure of the event object, see [Testing functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function) in the *Amazon CloudFront Developer Guide*.
     */
    public val eventObject: kotlin.ByteArray? = builder.eventObject
    /**
     * The current version (`ETag` value) of the function that you are testing, which you can get using `DescribeFunction`.
     */
    public val ifMatch: kotlin.String? = builder.ifMatch
    /**
     * The name of the function that you are testing.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The stage of the function that you are testing, either `DEVELOPMENT` or `LIVE`.
     */
    public val stage: aws.sdk.kotlin.services.cloudfront.model.FunctionStage? = builder.stage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestFunctionRequest(")
        append("eventObject=*** Sensitive Data Redacted ***,")
        append("ifMatch=$ifMatch,")
        append("name=$name,")
        append("stage=$stage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventObject?.contentHashCode() ?: 0
        result = 31 * result + (ifMatch?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestFunctionRequest

        if (eventObject != null) {
            if (other.eventObject == null) return false
            if (!eventObject.contentEquals(other.eventObject)) return false
        } else if (other.eventObject != null) return false
        if (ifMatch != other.ifMatch) return false
        if (name != other.name) return false
        if (stage != other.stage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The event object to test the function with. For more information about the structure of the event object, see [Testing functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function) in the *Amazon CloudFront Developer Guide*.
         */
        public var eventObject: kotlin.ByteArray? = null
        /**
         * The current version (`ETag` value) of the function that you are testing, which you can get using `DescribeFunction`.
         */
        public var ifMatch: kotlin.String? = null
        /**
         * The name of the function that you are testing.
         */
        public var name: kotlin.String? = null
        /**
         * The stage of the function that you are testing, either `DEVELOPMENT` or `LIVE`.
         */
        public var stage: aws.sdk.kotlin.services.cloudfront.model.FunctionStage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest) : this() {
            this.eventObject = x.eventObject
            this.ifMatch = x.ifMatch
            this.name = x.name
            this.stage = x.stage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest = TestFunctionRequest(this)
    }
}
