// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The RTMP distribution's configuration information.
 */
public class StreamingDistributionConfig private constructor(builder: Builder) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
     */
    public val aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = builder.aliases
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     *
     * If the value of `CallerReference` is new (regardless of the content of the `StreamingDistributionConfig` object), CloudFront creates a new distribution.
     *
     * If `CallerReference` is a value that you already sent in a previous request to create a distribution, CloudFront returns a `DistributionAlreadyExists` error.
     */
    public val callerReference: kotlin.String? = builder.callerReference
    /**
     * Any comments you want to include about the streaming distribution.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * Whether the streaming distribution is enabled to accept user requests for content.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A complex type that controls whether access logs are written for the streaming distribution.
     */
    public val logging: aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig? = builder.logging
    /**
     * A complex type that contains information about price class for this streaming distribution.
     */
    public val priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = builder.priceClass
    /**
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
     */
    public val s3Origin: aws.sdk.kotlin.services.cloudfront.model.S3Origin? = builder.s3Origin
    /**
     * A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed URLs for private content. If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = builder.trustedSigners

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistributionConfig(")
        append("aliases=$aliases,")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("enabled=$enabled,")
        append("logging=$logging,")
        append("priceClass=$priceClass,")
        append("s3Origin=$s3Origin,")
        append("trustedSigners=$trustedSigners")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (callerReference?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (s3Origin?.hashCode() ?: 0)
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamingDistributionConfig

        if (aliases != other.aliases) return false
        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (enabled != other.enabled) return false
        if (logging != other.logging) return false
        if (priceClass != other.priceClass) return false
        if (s3Origin != other.s3Origin) return false
        if (trustedSigners != other.trustedSigners) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming distribution.
         */
        public var aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = null
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         *
         * If the value of `CallerReference` is new (regardless of the content of the `StreamingDistributionConfig` object), CloudFront creates a new distribution.
         *
         * If `CallerReference` is a value that you already sent in a previous request to create a distribution, CloudFront returns a `DistributionAlreadyExists` error.
         */
        public var callerReference: kotlin.String? = null
        /**
         * Any comments you want to include about the streaming distribution.
         */
        public var comment: kotlin.String? = null
        /**
         * Whether the streaming distribution is enabled to accept user requests for content.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A complex type that controls whether access logs are written for the streaming distribution.
         */
        public var logging: aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig? = null
        /**
         * A complex type that contains information about price class for this streaming distribution.
         */
        public var priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = null
        /**
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
         */
        public var s3Origin: aws.sdk.kotlin.services.cloudfront.model.S3Origin? = null
        /**
         * A complex type that specifies any Amazon Web Services accounts that you want to permit to create signed URLs for private content. If you want the distribution to use signed URLs, include this element; if you want the distribution to use public URLs, remove this element. For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig) : this() {
            this.aliases = x.aliases
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.enabled = x.enabled
            this.logging = x.logging
            this.priceClass = x.priceClass
            this.s3Origin = x.s3Origin
            this.trustedSigners = x.trustedSigners
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig = StreamingDistributionConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        public fun aliases(block: aws.sdk.kotlin.services.cloudfront.model.Aliases.Builder.() -> kotlin.Unit) {
            this.aliases = aws.sdk.kotlin.services.cloudfront.model.Aliases.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3Origin] inside the given [block]
         */
        public fun s3Origin(block: aws.sdk.kotlin.services.cloudfront.model.S3Origin.Builder.() -> kotlin.Unit) {
            this.s3Origin = aws.sdk.kotlin.services.cloudfront.model.S3Origin.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        public fun trustedSigners(block: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.Builder.() -> kotlin.Unit) {
            this.trustedSigners = aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.invoke(block)
        }
    }
}
