// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A streaming distribution tells CloudFront where you want RTMP content to be delivered from, and the details about how to track and manage content delivery.
 */
public class StreamingDistribution private constructor(builder: Builder) {
    /**
     * A complex type that lists the Amazon Web Services accounts, if any, that you included in the `TrustedSigners` complex type for this distribution. These are the accounts that you want to allow to create signed URLs for private content.
     *
     * The `Signer` complex type lists the Amazon Web Services account number of the trusted signer or `self` if the signer is the Amazon Web Services account that created the distribution. The `Signer` element also includes the IDs of any active CloudFront key pairs that are associated with the trusted signer's Amazon Web Services account. If no `KeyPairId` element appears for a `Signer`, that signer can't create signed URLs.
     *
     * For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val activeTrustedSigners: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners? = builder.activeTrustedSigners
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The domain name that corresponds to the streaming distribution, for example, `s5c39gqb8ow64r.cloudfront.net`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The identifier for the RTMP distribution. For example: `EGTXBD79EXAMPLE`.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time that the distribution was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The current status of the RTMP distribution. When the status is `Deployed`, the distribution's information is propagated to all CloudFront edge locations.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The current configuration information for the RTMP distribution.
     */
    public val streamingDistributionConfig: aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig? = builder.streamingDistributionConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingDistribution(")
        append("activeTrustedSigners=$activeTrustedSigners,")
        append("arn=$arn,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("status=$status,")
        append("streamingDistributionConfig=$streamingDistributionConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeTrustedSigners?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (streamingDistributionConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamingDistribution

        if (activeTrustedSigners != other.activeTrustedSigners) return false
        if (arn != other.arn) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (status != other.status) return false
        if (streamingDistributionConfig != other.streamingDistributionConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that lists the Amazon Web Services accounts, if any, that you included in the `TrustedSigners` complex type for this distribution. These are the accounts that you want to allow to create signed URLs for private content.
         *
         * The `Signer` complex type lists the Amazon Web Services account number of the trusted signer or `self` if the signer is the Amazon Web Services account that created the distribution. The `Signer` element also includes the IDs of any active CloudFront key pairs that are associated with the trusted signer's Amazon Web Services account. If no `KeyPairId` element appears for a `Signer`, that signer can't create signed URLs.
         *
         * For more information, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var activeTrustedSigners: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners? = null
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
         */
        public var arn: kotlin.String? = null
        /**
         * The domain name that corresponds to the streaming distribution, for example, `s5c39gqb8ow64r.cloudfront.net`.
         */
        public var domainName: kotlin.String? = null
        /**
         * The identifier for the RTMP distribution. For example: `EGTXBD79EXAMPLE`.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time that the distribution was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the RTMP distribution. When the status is `Deployed`, the distribution's information is propagated to all CloudFront edge locations.
         */
        public var status: kotlin.String? = null
        /**
         * The current configuration information for the RTMP distribution.
         */
        public var streamingDistributionConfig: aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution) : this() {
            this.activeTrustedSigners = x.activeTrustedSigners
            this.arn = x.arn
            this.domainName = x.domainName
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.status = x.status
            this.streamingDistributionConfig = x.streamingDistributionConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution = StreamingDistribution(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners] inside the given [block]
         */
        public fun activeTrustedSigners(block: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners.Builder.() -> kotlin.Unit) {
            this.activeTrustedSigners = aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig] inside the given [block]
         */
        public fun streamingDistributionConfig(block: aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig.Builder.() -> kotlin.Unit) {
            this.streamingDistributionConfig = aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig.invoke(block)
        }
    }
}
