// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media files for distribution.
 */
public class S3Origin private constructor(builder: Builder) {
    /**
     * The DNS name of the Amazon S3 origin.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The CloudFront origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
     *
     * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
     *
     * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
     *
     * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
     *
     * For more information, see [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the * Amazon CloudFront Developer Guide*.
     */
    public val originAccessIdentity: kotlin.String? = builder.originAccessIdentity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.S3Origin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Origin(")
        append("domainName=$domainName,")
        append("originAccessIdentity=$originAccessIdentity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (originAccessIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Origin

        if (domainName != other.domainName) return false
        if (originAccessIdentity != other.originAccessIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.S3Origin = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DNS name of the Amazon S3 origin.
         */
        public var domainName: kotlin.String? = null
        /**
         * The CloudFront origin access identity to associate with the distribution. Use an origin access identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
         *
         * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
         *
         * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
         *
         * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         *
         * For more information, see [Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the * Amazon CloudFront Developer Guide*.
         */
        public var originAccessIdentity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.S3Origin) : this() {
            this.domainName = x.domainName
            this.originAccessIdentity = x.originAccessIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.S3Origin = S3Origin(this)
    }
}
