// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A response headers policy configuration.
 *
 * A response headers policy configuration contains metadata about the response headers policy, and configurations for sets of HTTP response headers.
 */
public class ResponseHeadersPolicyConfig private constructor(builder: Builder) {
    /**
     * A comment to describe the response headers policy.
     *
     * The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
     */
    public val corsConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig? = builder.corsConfig
    /**
     * A configuration for a set of custom HTTP response headers.
     */
    public val customHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig? = builder.customHeadersConfig
    /**
     * A name to identify the response headers policy.
     *
     * The name must be unique for response headers policies in this Amazon Web Services account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A configuration for a set of HTTP headers to remove from the HTTP response.
     */
    public val removeHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig? = builder.removeHeadersConfig
    /**
     * A configuration for a set of security-related HTTP response headers.
     */
    public val securityHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig? = builder.securityHeadersConfig
    /**
     * A configuration for enabling the `Server-Timing` header in HTTP responses sent from CloudFront.
     */
    public val serverTimingHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig? = builder.serverTimingHeadersConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicyConfig(")
        append("comment=$comment,")
        append("corsConfig=$corsConfig,")
        append("customHeadersConfig=$customHeadersConfig,")
        append("name=$name,")
        append("removeHeadersConfig=$removeHeadersConfig,")
        append("securityHeadersConfig=$securityHeadersConfig,")
        append("serverTimingHeadersConfig=$serverTimingHeadersConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (corsConfig?.hashCode() ?: 0)
        result = 31 * result + (customHeadersConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (removeHeadersConfig?.hashCode() ?: 0)
        result = 31 * result + (securityHeadersConfig?.hashCode() ?: 0)
        result = 31 * result + (serverTimingHeadersConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicyConfig

        if (comment != other.comment) return false
        if (corsConfig != other.corsConfig) return false
        if (customHeadersConfig != other.customHeadersConfig) return false
        if (name != other.name) return false
        if (removeHeadersConfig != other.removeHeadersConfig) return false
        if (securityHeadersConfig != other.securityHeadersConfig) return false
        if (serverTimingHeadersConfig != other.serverTimingHeadersConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A comment to describe the response headers policy.
         *
         * The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         */
        public var corsConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig? = null
        /**
         * A configuration for a set of custom HTTP response headers.
         */
        public var customHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig? = null
        /**
         * A name to identify the response headers policy.
         *
         * The name must be unique for response headers policies in this Amazon Web Services account.
         */
        public var name: kotlin.String? = null
        /**
         * A configuration for a set of HTTP headers to remove from the HTTP response.
         */
        public var removeHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig? = null
        /**
         * A configuration for a set of security-related HTTP response headers.
         */
        public var securityHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig? = null
        /**
         * A configuration for enabling the `Server-Timing` header in HTTP responses sent from CloudFront.
         */
        public var serverTimingHeadersConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig) : this() {
            this.comment = x.comment
            this.corsConfig = x.corsConfig
            this.customHeadersConfig = x.customHeadersConfig
            this.name = x.name
            this.removeHeadersConfig = x.removeHeadersConfig
            this.securityHeadersConfig = x.securityHeadersConfig
            this.serverTimingHeadersConfig = x.serverTimingHeadersConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig = ResponseHeadersPolicyConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig] inside the given [block]
         */
        public fun corsConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig.Builder.() -> kotlin.Unit) {
            this.corsConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig] inside the given [block]
         */
        public fun customHeadersConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.Builder.() -> kotlin.Unit) {
            this.customHeadersConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCustomHeadersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig] inside the given [block]
         */
        public fun removeHeadersConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.Builder.() -> kotlin.Unit) {
            this.removeHeadersConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig] inside the given [block]
         */
        public fun securityHeadersConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.Builder.() -> kotlin.Unit) {
            this.securityHeadersConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig] inside the given [block]
         */
        public fun serverTimingHeadersConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.Builder.() -> kotlin.Unit) {
            this.serverTimingHeadersConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.invoke(block)
        }
    }
}
