// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A response headers policy.
 *
 * A response headers policy contains information about a set of HTTP response headers.
 *
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or removes response headers according to the configuration of the response headers policy.
 *
 * For more information, see [Adding or removing HTTP headers in CloudFront responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html) in the *Amazon CloudFront Developer Guide*.
 */
public class ResponseHeadersPolicy private constructor(builder: Builder) {
    /**
     * The identifier for the response headers policy.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The date and time when the response headers policy was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A response headers policy configuration.
     */
    public val responseHeadersPolicyConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig? = builder.responseHeadersPolicyConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicy(")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("responseHeadersPolicyConfig=$responseHeadersPolicyConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (responseHeadersPolicyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicy

        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (responseHeadersPolicyConfig != other.responseHeadersPolicyConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the response headers policy.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time when the response headers policy was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A response headers policy configuration.
         */
        public var responseHeadersPolicyConfig: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicy) : this() {
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.responseHeadersPolicyConfig = x.responseHeadersPolicyConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicy = ResponseHeadersPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig] inside the given [block]
         */
        public fun responseHeadersPolicyConfig(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig.Builder.() -> kotlin.Unit) {
            this.responseHeadersPolicyConfig = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyConfig.invoke(block)
        }
    }
}
