// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in requests that CloudFront sends to the origin.
 */
public class OriginRequestPolicyQueryStringsConfig private constructor(builder: Builder) {
    /**
     * Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any query strings that are listed in a `CachePolicy`*are* included in origin requests.
     * + `whitelist` – Only the query strings in viewer requests that are listed in the `QueryStringNames` type are included in requests that CloudFront sends to the origin.
     * + `all` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
     * + `allExcept` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `QueryStringNames` type, which are not included.
     */
    public val queryStringBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringBehavior? = builder.queryStringBehavior
    /**
     * Contains the specific query strings in viewer requests that either ***are*** or ***are not*** included in requests that CloudFront sends to the origin. The behavior depends on whether the `QueryStringBehavior` field in the `OriginRequestPolicyQueryStringsConfig` type is set to `whitelist` (the listed query strings ***are*** included) or `allExcept` (the listed query strings ***are not*** included, but all other query strings are).
     */
    public val queryStrings: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames? = builder.queryStrings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyQueryStringsConfig(")
        append("queryStringBehavior=$queryStringBehavior,")
        append("queryStrings=$queryStrings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryStringBehavior?.hashCode() ?: 0
        result = 31 * result + (queryStrings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginRequestPolicyQueryStringsConfig

        if (queryStringBehavior != other.queryStringBehavior) return false
        if (queryStrings != other.queryStrings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether any URL query strings in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – No query strings in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any query strings that are listed in a `CachePolicy`*are* included in origin requests.
         * + `whitelist` – Only the query strings in viewer requests that are listed in the `QueryStringNames` type are included in requests that CloudFront sends to the origin.
         * + `all` – All query strings in viewer requests are included in requests that CloudFront sends to the origin.
         * + `allExcept` – All query strings in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `QueryStringNames` type, which are not included.
         */
        public var queryStringBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringBehavior? = null
        /**
         * Contains the specific query strings in viewer requests that either ***are*** or ***are not*** included in requests that CloudFront sends to the origin. The behavior depends on whether the `QueryStringBehavior` field in the `OriginRequestPolicyQueryStringsConfig` type is set to `whitelist` (the listed query strings ***are*** included) or `allExcept` (the listed query strings ***are not*** included, but all other query strings are).
         */
        public var queryStrings: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig) : this() {
            this.queryStringBehavior = x.queryStringBehavior
            this.queryStrings = x.queryStrings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig = OriginRequestPolicyQueryStringsConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.QueryStringNames] inside the given [block]
         */
        public fun queryStrings(block: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames.Builder.() -> kotlin.Unit) {
            this.queryStrings = aws.sdk.kotlin.services.cloudfront.model.QueryStringNames.invoke(block)
        }
    }
}
