// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls whether access logs are written for the distribution.
 */
public class LoggingConfig private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable logging when you create a distribution or if you want to disable logging for an existing distribution, specify `false` for `Enabled`, and specify empty `Bucket` and `Prefix` elements. If you specify `false` for `Enabled` but you specify values for `Bucket`, `prefix`, and `IncludeCookies`, the values are automatically deleted.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies whether you want CloudFront to include cookies in access logs, specify `true` for `IncludeCookies`. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify `false` for `IncludeCookies`.
     */
    public val includeCookies: kotlin.Boolean? = builder.includeCookies
    /**
     * An optional string that you want CloudFront to prefix to the access log `filenames` for this distribution, for example, `myprefix/`. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty `Prefix` element in the `Logging` element.
     */
    public val prefix: kotlin.String? = builder.prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.LoggingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfig(")
        append("bucket=$bucket,")
        append("enabled=$enabled,")
        append("includeCookies=$includeCookies,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (includeCookies?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfig

        if (bucket != other.bucket) return false
        if (enabled != other.enabled) return false
        if (includeCookies != other.includeCookies) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.LoggingConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
         */
        public var bucket: kotlin.String? = null
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable logging when you create a distribution or if you want to disable logging for an existing distribution, specify `false` for `Enabled`, and specify empty `Bucket` and `Prefix` elements. If you specify `false` for `Enabled` but you specify values for `Bucket`, `prefix`, and `IncludeCookies`, the values are automatically deleted.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specifies whether you want CloudFront to include cookies in access logs, specify `true` for `IncludeCookies`. If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify `false` for `IncludeCookies`.
         */
        public var includeCookies: kotlin.Boolean? = null
        /**
         * An optional string that you want CloudFront to prefix to the access log `filenames` for this distribution, for example, `myprefix/`. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty `Prefix` element in the `Logging` element.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.LoggingConfig) : this() {
            this.bucket = x.bucket
            this.enabled = x.enabled
            this.includeCookies = x.includeCookies
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.LoggingConfig = LoggingConfig(this)
    }
}
