// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that specifies a list of Lambda@Edge functions associations for a cache behavior.
 *
 * If you want to invoke one or more Lambda@Edge functions triggered by requests that match the `PathPattern` of the cache behavior, specify the applicable values for `Quantity` and `Items`. Note that there can be up to 4 `LambdaFunctionAssociation` items in this list (one for each possible value of `EventType`) and each `EventType` can be associated with only one function.
 *
 * If you don't want to invoke any Lambda@Edge functions for the requests that match `PathPattern`, specify `0` for `Quantity` and omit `Items`.
 */
public class LambdaFunctionAssociations private constructor(builder: Builder) {
    /**
     * **Optional**: A complex type that contains `LambdaFunctionAssociation` items for this cache behavior. If `Quantity` is `0`, you can omit `Items`.
     */
    public val items: List<LambdaFunctionAssociation>? = builder.items
    /**
     * The number of Lambda@Edge function associations for this cache behavior.
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAssociations(")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionAssociations

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations = Builder(this).apply(block).build()

    public class Builder {
        /**
         * **Optional**: A complex type that contains `LambdaFunctionAssociation` items for this cache behavior. If `Quantity` is `0`, you can omit `Items`.
         */
        public var items: List<LambdaFunctionAssociation>? = null
        /**
         * The number of Lambda@Edge function associations for this cache behavior.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations = LambdaFunctionAssociations(this)
    }
}
