// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
 */
public class KinesisStreamConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
     *
     * For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
     */
    public val streamArn: kotlin.String? = builder.streamArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.KinesisStreamConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamConfig(")
        append("roleArn=$roleArn,")
        append("streamArn=$streamArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisStreamConfig

        if (roleArn != other.roleArn) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.KinesisStreamConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFront can use to send real-time log data to your Kinesis data stream.
         *
         * For more information the IAM role, see [Real-time log configuration IAM role](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role) in the *Amazon CloudFront Developer Guide*.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Kinesis data stream where you are sending real-time log data.
         */
        public var streamArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.KinesisStreamConfig) : this() {
            this.roleArn = x.roleArn
            this.streamArn = x.streamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.KinesisStreamConfig = KinesisStreamConfig(this)
    }
}
