// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A key group.
 *
 * A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
 */
public class KeyGroup private constructor(builder: Builder) {
    /**
     * The identifier for the key group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The key group configuration.
     */
    public val keyGroupConfig: aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig? = builder.keyGroupConfig
    /**
     * The date and time when the key group was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.KeyGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyGroup(")
        append("id=$id,")
        append("keyGroupConfig=$keyGroupConfig,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (keyGroupConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyGroup

        if (id != other.id) return false
        if (keyGroupConfig != other.keyGroupConfig) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.KeyGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the key group.
         */
        public var id: kotlin.String? = null
        /**
         * The key group configuration.
         */
        public var keyGroupConfig: aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig? = null
        /**
         * The date and time when the key group was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.KeyGroup) : this() {
            this.id = x.id
            this.keyGroupConfig = x.keyGroupConfig
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.KeyGroup = KeyGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig] inside the given [block]
         */
        public fun keyGroupConfig(block: aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig.Builder.() -> kotlin.Unit) {
            this.keyGroupConfig = aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig.invoke(block)
        }
    }
}
