// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * The `InvalidationList` complex type describes the list of invalidation objects. For more information about invalidation, see [Invalidating Objects (Web Distributions Only)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html) in the *Amazon CloudFront Developer Guide*.
 */
public class InvalidationList private constructor(builder: Builder) {
    /**
     * A flag that indicates whether more invalidation batch requests remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more invalidation batches in the list.
     */
    public val isTruncated: kotlin.Boolean? = builder.isTruncated
    /**
     * A complex type that contains one `InvalidationSummary` element for each invalidation batch created by the current Amazon Web Services account.
     */
    public val items: List<InvalidationSummary>? = builder.items
    /**
     * The value that you provided for the `Marker` request parameter.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The value that you provided for the `MaxItems` request parameter.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If `IsTruncated` is `true`, this element is present and contains the value that you can use for the `Marker` request parameter to continue listing your invalidation batches where they left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The number of invalidation batches that were created by the current Amazon Web Services account.
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.InvalidationList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidationList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidationList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.InvalidationList = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag that indicates whether more invalidation batch requests remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more invalidation batches in the list.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * A complex type that contains one `InvalidationSummary` element for each invalidation batch created by the current Amazon Web Services account.
         */
        public var items: List<InvalidationSummary>? = null
        /**
         * The value that you provided for the `Marker` request parameter.
         */
        public var marker: kotlin.String? = null
        /**
         * The value that you provided for the `MaxItems` request parameter.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, this element is present and contains the value that you can use for the `Marker` request parameter to continue listing your invalidation batches where they left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The number of invalidation batches that were created by the current Amazon Web Services account.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.InvalidationList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.InvalidationList = InvalidationList(this)
    }
}
