// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls the countries in which your content is distributed. CloudFront determines the location of your users using `MaxMind` GeoIP databases.
 */
public class GeoRestriction private constructor(builder: Builder) {
    /**
     * A complex type that contains a `Location` element for each country in which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`).
     *
     * The `Location` element is a two-letter, uppercase country code for a country that you want to include in your `blacklist` or `whitelist`. Include one `Location` element for each country.
     *
     * CloudFront and `MaxMind` both use `ISO 3166` country codes. For the current list of countries and the corresponding codes, see `ISO 3166-1-alpha-2` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
     */
    public val items: List<String>? = builder.items
    /**
     * When geo restriction is `enabled`, this is the number of countries in your `whitelist` or `blacklist`. Otherwise, when it is not enabled, `Quantity` is `0`, and you can omit `Items`.
     */
    public val quantity: kotlin.Int? = builder.quantity
    /**
     * The method that you want to use to restrict distribution of your content by country:
     * + `none`: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
     * + `blacklist`: The `Location` elements specify the countries in which you don't want CloudFront to distribute your content.
     * + `whitelist`: The `Location` elements specify the countries in which you want CloudFront to distribute your content.
     */
    public val restrictionType: aws.sdk.kotlin.services.cloudfront.model.GeoRestrictionType? = builder.restrictionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.GeoRestriction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeoRestriction(")
        append("items=$items,")
        append("quantity=$quantity,")
        append("restrictionType=$restrictionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        result = 31 * result + (restrictionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeoRestriction

        if (items != other.items) return false
        if (quantity != other.quantity) return false
        if (restrictionType != other.restrictionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.GeoRestriction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains a `Location` element for each country in which you want CloudFront either to distribute your content (`whitelist`) or not distribute your content (`blacklist`).
         *
         * The `Location` element is a two-letter, uppercase country code for a country that you want to include in your `blacklist` or `whitelist`. Include one `Location` element for each country.
         *
         * CloudFront and `MaxMind` both use `ISO 3166` country codes. For the current list of countries and the corresponding codes, see `ISO 3166-1-alpha-2` code on the *International Organization for Standardization* website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
         */
        public var items: List<String>? = null
        /**
         * When geo restriction is `enabled`, this is the number of countries in your `whitelist` or `blacklist`. Otherwise, when it is not enabled, `Quantity` is `0`, and you can omit `Items`.
         */
        public var quantity: kotlin.Int? = null
        /**
         * The method that you want to use to restrict distribution of your content by country:
         * + `none`: No geo restriction is enabled, meaning access to content is not restricted by client geo location.
         * + `blacklist`: The `Location` elements specify the countries in which you don't want CloudFront to distribute your content.
         * + `whitelist`: The `Location` elements specify the countries in which you want CloudFront to distribute your content.
         */
        public var restrictionType: aws.sdk.kotlin.services.cloudfront.model.GeoRestrictionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.GeoRestriction) : this() {
            this.items = x.items
            this.quantity = x.quantity
            this.restrictionType = x.restrictionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.GeoRestriction = GeoRestriction(this)
    }
}
