// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A distribution configuration.
 */
public class DistributionConfig private constructor(builder: Builder) {
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     */
    public val aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = builder.aliases
    /**
     * A complex type that contains zero or more `CacheBehavior` elements.
     */
    public val cacheBehaviors: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors? = builder.cacheBehaviors
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     *
     * If the value of `CallerReference` is new (regardless of the content of the `DistributionConfig` object), CloudFront creates a new distribution.
     *
     * If `CallerReference` is a value that you already sent in a previous request to create a distribution, CloudFront returns a `DistributionAlreadyExists` error.
     */
    public val callerReference: kotlin.String? = builder.callerReference
    /**
     * A comment to describe the distribution. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The identifier of a continuous deployment policy. For more information, see `CreateContinuousDeploymentPolicy`.
     */
    public val continuousDeploymentPolicyId: kotlin.String? = builder.continuousDeploymentPolicyId
    /**
     * A complex type that controls the following:
     * + Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
     * + How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     *
     * For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val customErrorResponses: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses? = builder.customErrorResponses
    /**
     * A complex type that describes the default cache behavior if you don't specify a `CacheBehavior` element or if files don't match any of the values of `PathPattern` in `CacheBehavior` elements. You must create exactly one default cache behavior.
     */
    public val defaultCacheBehavior: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior? = builder.defaultCacheBehavior
    /**
     * The object that you want CloudFront to request from your origin (for example, `index.html`) when a viewer requests the root URL for your distribution (`https://www.example.com`) instead of an object in your distribution (`https://www.example.com/product-description.html`). Specifying a default root object avoids exposing the contents of your distribution.
     *
     * Specify only the object name, for example, `index.html`. Don't add a `/` before the object name.
     *
     * If you don't want to specify a default root object when you create a distribution, include an empty `DefaultRootObject` element.
     *
     * To delete the default root object from an existing distribution, update the distribution configuration and include an empty `DefaultRootObject` element.
     *
     * To replace the default root object, update the distribution configuration and specify the new object.
     *
     * For more information about the default root object, see [Creating a Default Root Object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val defaultRootObject: kotlin.String? = builder.defaultRootObject
    /**
     * From this field, you can enable or disable the selected distribution.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CloudFront. The default value for new web distributions is `http2`. Viewers that don't support HTTP/2 automatically use an earlier HTTP version.
     *
     * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
     *
     * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
     */
    public val httpVersion: aws.sdk.kotlin.services.cloudfront.model.HttpVersion? = builder.httpVersion
    /**
     * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify `true`. If you specify `false`, CloudFront responds to IPv6 DNS requests with the DNS response code `NOERROR` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
     *
     * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the `IpAddress` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
     *
     * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
     * + You enable IPv6 for the distribution
     * + You're using alternate domain names in the URLs for your objects
     *
     * For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Route 53 Amazon Web Services Integration Developer Guide*.
     *
     * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
     */
    public val isIpv6Enabled: kotlin.Boolean? = builder.isIpv6Enabled
    /**
     * A complex type that controls whether access logs are written for the distribution.
     *
     * For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val logging: aws.sdk.kotlin.services.cloudfront.model.LoggingConfig? = builder.logging
    /**
     * A complex type that contains information about origin groups for this distribution.
     */
    public val originGroups: aws.sdk.kotlin.services.cloudfront.model.OriginGroups? = builder.originGroups
    /**
     * A complex type that contains information about origins for this distribution.
     */
    public val origins: aws.sdk.kotlin.services.cloudfront.model.Origins? = builder.origins
    /**
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify `PriceClass_All`, CloudFront responds to requests for your objects from all CloudFront edge locations.
     *
     * If you specify a price class other than `PriceClass_All`, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
     *
     * For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](http://aws.amazon.com/cloudfront/pricing/).
     */
    public val priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = builder.priceClass
    /**
     * A complex type that identifies ways in which you want to restrict distribution of your content.
     */
    public val restrictions: aws.sdk.kotlin.services.cloudfront.model.Restrictions? = builder.restrictions
    /**
     * A Boolean that indicates whether this is a staging distribution. When this value is `true`, this is a staging distribution. When this value is `false`, this is not a staging distribution.
     */
    public val staging: kotlin.Boolean? = builder.staging
    /**
     * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     */
    public val viewerCertificate: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate? = builder.viewerCertificate
    /**
     * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a`. To specify a web ACL created using WAF Classic, use the ACL ID, for example `473e64fd-f30b-4765-81a0-62ad96dd167a`.
     *
     * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
     */
    public val webAclId: kotlin.String? = builder.webAclId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.DistributionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionConfig(")
        append("aliases=$aliases,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("callerReference=$callerReference,")
        append("comment=*** Sensitive Data Redacted ***,")
        append("continuousDeploymentPolicyId=$continuousDeploymentPolicyId,")
        append("customErrorResponses=$customErrorResponses,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("defaultRootObject=$defaultRootObject,")
        append("enabled=$enabled,")
        append("httpVersion=$httpVersion,")
        append("isIpv6Enabled=$isIpv6Enabled,")
        append("logging=$logging,")
        append("originGroups=$originGroups,")
        append("origins=$origins,")
        append("priceClass=$priceClass,")
        append("restrictions=$restrictions,")
        append("staging=$staging,")
        append("viewerCertificate=$viewerCertificate,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (callerReference?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (continuousDeploymentPolicyId?.hashCode() ?: 0)
        result = 31 * result + (customErrorResponses?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (defaultRootObject?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (httpVersion?.hashCode() ?: 0)
        result = 31 * result + (isIpv6Enabled?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (originGroups?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (priceClass?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (staging?.hashCode() ?: 0)
        result = 31 * result + (viewerCertificate?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DistributionConfig

        if (aliases != other.aliases) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (continuousDeploymentPolicyId != other.continuousDeploymentPolicyId) return false
        if (customErrorResponses != other.customErrorResponses) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (defaultRootObject != other.defaultRootObject) return false
        if (enabled != other.enabled) return false
        if (httpVersion != other.httpVersion) return false
        if (isIpv6Enabled != other.isIpv6Enabled) return false
        if (logging != other.logging) return false
        if (originGroups != other.originGroups) return false
        if (origins != other.origins) return false
        if (priceClass != other.priceClass) return false
        if (restrictions != other.restrictions) return false
        if (staging != other.staging) return false
        if (viewerCertificate != other.viewerCertificate) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.DistributionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
         */
        public var aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = null
        /**
         * A complex type that contains zero or more `CacheBehavior` elements.
         */
        public var cacheBehaviors: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors? = null
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         *
         * If the value of `CallerReference` is new (regardless of the content of the `DistributionConfig` object), CloudFront creates a new distribution.
         *
         * If `CallerReference` is a value that you already sent in a previous request to create a distribution, CloudFront returns a `DistributionAlreadyExists` error.
         */
        public var callerReference: kotlin.String? = null
        /**
         * A comment to describe the distribution. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * The identifier of a continuous deployment policy. For more information, see `CreateContinuousDeploymentPolicy`.
         */
        public var continuousDeploymentPolicyId: kotlin.String? = null
        /**
         * A complex type that controls the following:
         * + Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
         * + How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         *
         * For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var customErrorResponses: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses? = null
        /**
         * A complex type that describes the default cache behavior if you don't specify a `CacheBehavior` element or if files don't match any of the values of `PathPattern` in `CacheBehavior` elements. You must create exactly one default cache behavior.
         */
        public var defaultCacheBehavior: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior? = null
        /**
         * The object that you want CloudFront to request from your origin (for example, `index.html`) when a viewer requests the root URL for your distribution (`https://www.example.com`) instead of an object in your distribution (`https://www.example.com/product-description.html`). Specifying a default root object avoids exposing the contents of your distribution.
         *
         * Specify only the object name, for example, `index.html`. Don't add a `/` before the object name.
         *
         * If you don't want to specify a default root object when you create a distribution, include an empty `DefaultRootObject` element.
         *
         * To delete the default root object from an existing distribution, update the distribution configuration and include an empty `DefaultRootObject` element.
         *
         * To replace the default root object, update the distribution configuration and specify the new object.
         *
         * For more information about the default root object, see [Creating a Default Root Object](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var defaultRootObject: kotlin.String? = null
        /**
         * From this field, you can enable or disable the selected distribution.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CloudFront. The default value for new web distributions is `http2`. Viewers that don't support HTTP/2 automatically use an earlier HTTP version.
         *
         * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         *
         * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see [Connection Migration](https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration) at RFC 9000. For more information about supported TLSv1.3 ciphers, see [Supported protocols and ciphers between viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html).
         */
        public var httpVersion: aws.sdk.kotlin.services.cloudfront.model.HttpVersion? = null
        /**
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify `true`. If you specify `false`, CloudFront responds to IPv6 DNS requests with the DNS response code `NOERROR` and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         *
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the `IpAddress` parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see [Creating a Signed URL Using a Custom Policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html) in the *Amazon CloudFront Developer Guide*.
         *
         * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
         * + You enable IPv6 for the distribution
         * + You're using alternate domain names in the URLs for your objects
         *
         * For more information, see [Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html) in the *Route 53 Amazon Web Services Integration Developer Guide*.
         *
         * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
         */
        public var isIpv6Enabled: kotlin.Boolean? = null
        /**
         * A complex type that controls whether access logs are written for the distribution.
         *
         * For more information about logging, see [Access Logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var logging: aws.sdk.kotlin.services.cloudfront.model.LoggingConfig? = null
        /**
         * A complex type that contains information about origin groups for this distribution.
         */
        public var originGroups: aws.sdk.kotlin.services.cloudfront.model.OriginGroups? = null
        /**
         * A complex type that contains information about origins for this distribution.
         */
        public var origins: aws.sdk.kotlin.services.cloudfront.model.Origins? = null
        /**
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you specify `PriceClass_All`, CloudFront responds to requests for your objects from all CloudFront edge locations.
         *
         * If you specify a price class other than `PriceClass_All`, CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         *
         * For more information about price classes, see [Choosing the Price Class for a CloudFront Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html) in the *Amazon CloudFront Developer Guide*. For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see [Amazon CloudFront Pricing](http://aws.amazon.com/cloudfront/pricing/).
         */
        public var priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = null
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         */
        public var restrictions: aws.sdk.kotlin.services.cloudfront.model.Restrictions? = null
        /**
         * A Boolean that indicates whether this is a staging distribution. When this value is `true`, this is a staging distribution. When this value is `false`, this is not a staging distribution.
         */
        public var staging: kotlin.Boolean? = null
        /**
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         */
        public var viewerCertificate: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate? = null
        /**
         * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of WAF, use the ACL ARN, for example `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a`. To specify a web ACL created using WAF Classic, use the ACL ID, for example `473e64fd-f30b-4765-81a0-62ad96dd167a`.
         *
         * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about WAF, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.DistributionConfig) : this() {
            this.aliases = x.aliases
            this.cacheBehaviors = x.cacheBehaviors
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.continuousDeploymentPolicyId = x.continuousDeploymentPolicyId
            this.customErrorResponses = x.customErrorResponses
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.defaultRootObject = x.defaultRootObject
            this.enabled = x.enabled
            this.httpVersion = x.httpVersion
            this.isIpv6Enabled = x.isIpv6Enabled
            this.logging = x.logging
            this.originGroups = x.originGroups
            this.origins = x.origins
            this.priceClass = x.priceClass
            this.restrictions = x.restrictions
            this.staging = x.staging
            this.viewerCertificate = x.viewerCertificate
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.DistributionConfig = DistributionConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        public fun aliases(block: aws.sdk.kotlin.services.cloudfront.model.Aliases.Builder.() -> kotlin.Unit) {
            this.aliases = aws.sdk.kotlin.services.cloudfront.model.Aliases.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors] inside the given [block]
         */
        public fun cacheBehaviors(block: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors.Builder.() -> kotlin.Unit) {
            this.cacheBehaviors = aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses] inside the given [block]
         */
        public fun customErrorResponses(block: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses.Builder.() -> kotlin.Unit) {
            this.customErrorResponses = aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior] inside the given [block]
         */
        public fun defaultCacheBehavior(block: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior.Builder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.LoggingConfig] inside the given [block]
         */
        public fun logging(block: aws.sdk.kotlin.services.cloudfront.model.LoggingConfig.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.cloudfront.model.LoggingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroups] inside the given [block]
         */
        public fun originGroups(block: aws.sdk.kotlin.services.cloudfront.model.OriginGroups.Builder.() -> kotlin.Unit) {
            this.originGroups = aws.sdk.kotlin.services.cloudfront.model.OriginGroups.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Origins] inside the given [block]
         */
        public fun origins(block: aws.sdk.kotlin.services.cloudfront.model.Origins.Builder.() -> kotlin.Unit) {
            this.origins = aws.sdk.kotlin.services.cloudfront.model.Origins.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Restrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.cloudfront.model.Restrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.cloudfront.model.Restrictions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate] inside the given [block]
         */
        public fun viewerCertificate(block: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate.Builder.() -> kotlin.Unit) {
            this.viewerCertificate = aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate.invoke(block)
        }
    }
}
