// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls:
 * + Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.
 * + How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
 *
 * For more information about custom error pages, see [Customizing Error Responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html) in the *Amazon CloudFront Developer Guide*.
 */
public class CustomErrorResponses private constructor(builder: Builder) {
    /**
     * A complex type that contains a `CustomErrorResponse` element for each HTTP status code for which you want to specify a custom error page and/or a caching duration.
     */
    public val items: List<CustomErrorResponse>? = builder.items
    /**
     * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration. If `Quantity` is `0`, you can omit `Items`.
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomErrorResponses(")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomErrorResponses

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains a `CustomErrorResponse` element for each HTTP status code for which you want to specify a custom error page and/or a caching duration.
         */
        public var items: List<CustomErrorResponse>? = null
        /**
         * The number of HTTP status codes for which you want to specify a custom error page and/or a caching duration. If `Quantity` is `0`, you can omit `Items`.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses = CustomErrorResponses(this)
    }
}
