// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A list of aliases (also called CNAMEs) and the CloudFront distributions and Amazon Web Services accounts that they are associated with. In the list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
 */
public class ConflictingAliasesList private constructor(builder: Builder) {
    /**
     * Contains the conflicting aliases in the list.
     */
    public val items: List<ConflictingAlias>? = builder.items
    /**
     * The maximum number of conflicting aliases requested.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing conflicting aliases where you left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The number of conflicting aliases returned in the response.
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ConflictingAliasesList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictingAliasesList(")
        append("items=$items,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictingAliasesList

        if (items != other.items) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ConflictingAliasesList = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains the conflicting aliases in the list.
         */
        public var items: List<ConflictingAlias>? = null
        /**
         * The maximum number of conflicting aliases requested.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing conflicting aliases where you left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The number of conflicting aliases returned in the response.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ConflictingAliasesList) : this() {
            this.items = x.items
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ConflictingAliasesList = ConflictingAliasesList(this)
    }
}
