// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An alias (also called a CNAME) and the CloudFront distribution and Amazon Web Services account ID that it's associated with. The distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
 */
public class ConflictingAlias private constructor(builder: Builder) {
    /**
     * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that's associated with the alias.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An alias (also called a CNAME).
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The (partially hidden) ID of the CloudFront distribution associated with the alias.
     */
    public val distributionId: kotlin.String? = builder.distributionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ConflictingAlias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictingAlias(")
        append("accountId=$accountId,")
        append("alias=$alias,")
        append("distributionId=$distributionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (alias?.hashCode() ?: 0)
        result = 31 * result + (distributionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictingAlias

        if (accountId != other.accountId) return false
        if (alias != other.alias) return false
        if (distributionId != other.distributionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ConflictingAlias = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The (partially hidden) ID of the Amazon Web Services account that owns the distribution that's associated with the alias.
         */
        public var accountId: kotlin.String? = null
        /**
         * An alias (also called a CNAME).
         */
        public var alias: kotlin.String? = null
        /**
         * The (partially hidden) ID of the CloudFront distribution associated with the alias.
         */
        public var distributionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ConflictingAlias) : this() {
            this.accountId = x.accountId
            this.alias = x.alias
            this.distributionId = x.distributionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ConflictingAlias = ConflictingAlias(this)
    }
}
