// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * Origin access identity configuration. Send a `GET` request to the `/<i>CloudFront API version</i>/CloudFront/identity ID/config` resource.
 */
public class CloudFrontOriginAccessIdentityConfig private constructor(builder: Builder) {
    /**
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     *
     * If the value of `CallerReference` is new (regardless of the content of the `CloudFrontOriginAccessIdentityConfig` object), a new origin access identity is created.
     *
     * If the `CallerReference` is a value already sent in a previous identity request, and the content of the `CloudFrontOriginAccessIdentityConfig` is identical to the original request (ignoring white space), the response includes the same information returned to the original request.
     *
     * If the `CallerReference` is a value you already sent in a previous request to create an identity, but the content of the `CloudFrontOriginAccessIdentityConfig` is different from the original request, CloudFront returns a `CloudFrontOriginAccessIdentityAlreadyExists` error.
     */
    public val callerReference: kotlin.String? = builder.callerReference
    /**
     * A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentityConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFrontOriginAccessIdentityConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         *
         * If the value of `CallerReference` is new (regardless of the content of the `CloudFrontOriginAccessIdentityConfig` object), a new origin access identity is created.
         *
         * If the `CallerReference` is a value already sent in a previous identity request, and the content of the `CloudFrontOriginAccessIdentityConfig` is identical to the original request (ignoring white space), the response includes the same information returned to the original request.
         *
         * If the `CallerReference` is a value you already sent in a previous request to create an identity, but the content of the `CloudFrontOriginAccessIdentityConfig` is different from the original request, CloudFront returns a `CloudFrontOriginAccessIdentityAlreadyExists` error.
         */
        public var callerReference: kotlin.String? = null
        /**
         * A comment to describe the origin access identity. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig(this)
    }
}
