// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods. There are two choices:
 * + CloudFront caches responses to `GET` and `HEAD` requests.
 * + CloudFront caches responses to `GET`, `HEAD`, and `OPTIONS` requests.
 *
 * If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
 */
public class CachedMethods private constructor(builder: Builder) {
    /**
     * A complex type that contains the HTTP methods that you want CloudFront to cache responses to.
     */
    public val items: List<Method>? = builder.items
    /**
     * The number of HTTP methods for which you want CloudFront to cache responses. Valid values are `2` (for caching responses to `GET` and `HEAD` requests) and `3` (for caching responses to `GET`, `HEAD`, and `OPTIONS` requests).
     */
    public val quantity: kotlin.Int? = builder.quantity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachedMethods = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachedMethods(")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (quantity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachedMethods

        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachedMethods = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains the HTTP methods that you want CloudFront to cache responses to.
         */
        public var items: List<Method>? = null
        /**
         * The number of HTTP methods for which you want CloudFront to cache responses. Valid values are `2` (for caching responses to `GET` and `HEAD` requests) and `3` (for caching responses to `GET`, `HEAD`, and `OPTIONS` requests).
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachedMethods) : this() {
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachedMethods = CachedMethods(this)
    }
}
