// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any URL query strings in viewer requests (and if so, which query strings) are included in the cache key and in requests that CloudFront sends to the origin.
 */
public class CachePolicyQueryStringsConfig private constructor(builder: Builder) {
    /**
     * Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to `none`, any query strings that are listed in an `OriginRequestPolicy`*are* included in origin requests.
     * + `whitelist` – Only the query strings in viewer requests that are listed in the `QueryStringNames` type are included in the cache key and in requests that CloudFront sends to the origin.
     * + `allExcept` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, ***except*** those that are listed in the `QueryStringNames` type, which are not included.
     * + `all` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
     */
    public val queryStringBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringBehavior? = builder.queryStringBehavior
    /**
     * Contains the specific query strings in viewer requests that either ***are*** or ***are not*** included in the cache key and in requests that CloudFront sends to the origin. The behavior depends on whether the `QueryStringBehavior` field in the `CachePolicyQueryStringsConfig` type is set to `whitelist` (the listed query strings ***are*** included) or `allExcept` (the listed query strings ***are not*** included, but all other query strings are).
     */
    public val queryStrings: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames? = builder.queryStrings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyQueryStringsConfig(")
        append("queryStringBehavior=$queryStringBehavior,")
        append("queryStrings=$queryStrings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryStringBehavior?.hashCode() ?: 0
        result = 31 * result + (queryStrings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicyQueryStringsConfig

        if (queryStringBehavior != other.queryStringBehavior) return false
        if (queryStrings != other.queryStrings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether any URL query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – No query strings in viewer requests are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to `none`, any query strings that are listed in an `OriginRequestPolicy`*are* included in origin requests.
         * + `whitelist` – Only the query strings in viewer requests that are listed in the `QueryStringNames` type are included in the cache key and in requests that CloudFront sends to the origin.
         * + `allExcept` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin, ***except*** those that are listed in the `QueryStringNames` type, which are not included.
         * + `all` – All query strings in viewer requests are included in the cache key and in requests that CloudFront sends to the origin.
         */
        public var queryStringBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringBehavior? = null
        /**
         * Contains the specific query strings in viewer requests that either ***are*** or ***are not*** included in the cache key and in requests that CloudFront sends to the origin. The behavior depends on whether the `QueryStringBehavior` field in the `CachePolicyQueryStringsConfig` type is set to `whitelist` (the listed query strings ***are*** included) or `allExcept` (the listed query strings ***are not*** included, but all other query strings are).
         */
        public var queryStrings: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig) : this() {
            this.queryStringBehavior = x.queryStringBehavior
            this.queryStrings = x.queryStrings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicyQueryStringsConfig = CachePolicyQueryStringsConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.QueryStringNames] inside the given [block]
         */
        public fun queryStrings(block: aws.sdk.kotlin.services.cloudfront.model.QueryStringNames.Builder.() -> kotlin.Unit) {
            this.queryStrings = aws.sdk.kotlin.services.cloudfront.model.QueryStringNames.invoke(block)
        }
    }
}
