// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model



/**
 * An object that determines whether any HTTP headers (and if so, which headers) are included in the cache key and in requests that CloudFront sends to the origin.
 */
public class CachePolicyHeadersConfig private constructor(builder: Builder) {
    /**
     * Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to `none`, any headers that are listed in an `OriginRequestPolicy`*are* included in origin requests.
     * + `whitelist` – Only the HTTP headers that are listed in the `Headers` type are included in the cache key and in requests that CloudFront sends to the origin.
     */
    public val headerBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeaderBehavior? = builder.headerBehavior
    /**
     * Contains a list of HTTP header names.
     */
    public val headers: aws.sdk.kotlin.services.cloudfront.model.Headers? = builder.headers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyHeadersConfig(")
        append("headerBehavior=$headerBehavior,")
        append("headers=$headers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerBehavior?.hashCode() ?: 0
        result = 31 * result + (headers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicyHeadersConfig

        if (headerBehavior != other.headerBehavior) return false
        if (headers != other.headers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether any HTTP headers are included in the cache key and in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – No HTTP headers are included in the cache key or in requests that CloudFront sends to the origin. Even when this field is set to `none`, any headers that are listed in an `OriginRequestPolicy`*are* included in origin requests.
         * + `whitelist` – Only the HTTP headers that are listed in the `Headers` type are included in the cache key and in requests that CloudFront sends to the origin.
         */
        public var headerBehavior: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeaderBehavior? = null
        /**
         * Contains a list of HTTP header names.
         */
        public var headers: aws.sdk.kotlin.services.cloudfront.model.Headers? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig) : this() {
            this.headerBehavior = x.headerBehavior
            this.headers = x.headers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicyHeadersConfig = CachePolicyHeadersConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Headers] inside the given [block]
         */
        public fun headers(block: aws.sdk.kotlin.services.cloudfront.model.Headers.Builder.() -> kotlin.Unit) {
            this.headers = aws.sdk.kotlin.services.cloudfront.model.Headers.invoke(block)
        }
    }
}
