// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.endpoints

import aws.sdk.kotlin.services.cloudfront.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContext
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding
import aws.smithy.kotlin.runtime.util.attributesOf

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultCloudFrontEndpointProvider: CloudFrontEndpointProvider {
    public override suspend fun resolveEndpoint(params: CloudFrontEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint, UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        partitionResult?.name == "aws" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://cloudfront.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    SigningContext.SigV4(
                                        signingName = "cloudfront",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws" &&
                        params.useFips == true &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://cloudfront-fips.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    SigningContext.SigV4(
                                        signingName = "cloudfront",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-east-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        partitionResult?.name == "aws-cn" &&
                        params.useFips == false &&
                        params.useDualStack == false
                    ) {
                        return Endpoint(
                            Url.parse("https://cloudfront.cn-northwest-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    SigningContext.SigV4(
                                        signingName = "cloudfront",
                                        disableDoubleEncoding = false,
                                        signingRegion = "cn-northwest-1",
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://cloudfront-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS
                        ) {
                            return Endpoint(
                                Url.parse("https://cloudfront-fips.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://cloudfront.${params.region}.${partitionResult?.dualStackDnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    return Endpoint(
                        Url.parse("https://cloudfront.${params.region}.${partitionResult?.dnsSuffix}", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
