// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.UpdateStackInstancesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class UpdateStackInstancesOperationDeserializer: HttpDeserialize<UpdateStackInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateStackInstancesResponse {
        if (!response.status.isSuccess()) {
            throwUpdateStackInstancesError(context, response)
        }
        val builder = UpdateStackInstancesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateStackInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateStackInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationIdAlreadyExistsException" -> OperationIdAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationInProgressException" -> OperationInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "StackInstanceNotFoundException" -> StackInstanceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "StackSetNotFoundException" -> StackSetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "StaleRequestException" -> StaleRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateStackInstancesOperationBody(builder: UpdateStackInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("UpdateStackInstancesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("UpdateStackInstancesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap UpdateStackInstances response")
    }
    // end unwrap response wrapper

    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("OperationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("UpdateStackInstancesResult"))
        field(OPERATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                OPERATIONID_DESCRIPTOR.index -> builder.operationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
