// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
import aws.sdk.kotlin.services.cloudformation.model.StackDriftDetectionStatus
import aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeStackDriftDetectionStatusOperationDeserializer: HttpDeserialize<DescribeStackDriftDetectionStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeStackDriftDetectionStatusResponse {
        if (!response.status.isSuccess()) {
            throwDescribeStackDriftDetectionStatusError(context, response)
        }
        val builder = DescribeStackDriftDetectionStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeStackDriftDetectionStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeStackDriftDetectionStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStackDriftDetectionStatusOperationBody(builder: DescribeStackDriftDetectionStatusResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeStackDriftDetectionStatusResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeStackDriftDetectionStatusResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeStackDriftDetectionStatus response")
    }
    // end unwrap response wrapper

    val DETECTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("DetectionStatus"))
    val DETECTIONSTATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DetectionStatusReason"))
    val DRIFTEDSTACKRESOURCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("DriftedStackResourceCount"))
    val STACKDRIFTDETECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackDriftDetectionId"))
    val STACKDRIFTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("StackDriftStatus"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("StackId"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("Timestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("DescribeStackDriftDetectionStatusResult"))
        field(DETECTIONSTATUS_DESCRIPTOR)
        field(DETECTIONSTATUSREASON_DESCRIPTOR)
        field(DRIFTEDSTACKRESOURCECOUNT_DESCRIPTOR)
        field(STACKDRIFTDETECTIONID_DESCRIPTOR)
        field(STACKDRIFTSTATUS_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DETECTIONSTATUS_DESCRIPTOR.index -> builder.detectionStatus = deserializeString().let { StackDriftDetectionStatus.fromValue(it) }
                DETECTIONSTATUSREASON_DESCRIPTOR.index -> builder.detectionStatusReason = deserializeString()
                DRIFTEDSTACKRESOURCECOUNT_DESCRIPTOR.index -> builder.driftedStackResourceCount = deserializeInt()
                STACKDRIFTDETECTIONID_DESCRIPTOR.index -> builder.stackDriftDetectionId = deserializeString()
                STACKDRIFTSTATUS_DESCRIPTOR.index -> builder.stackDriftStatus = deserializeString().let { StackDriftStatus.fromValue(it) }
                STACKID_DESCRIPTOR.index -> builder.stackId = deserializeString()
                TIMESTAMP_DESCRIPTOR.index -> builder.timestamp = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
