// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribePublisherResponse
import aws.sdk.kotlin.services.cloudformation.model.IdentityProvider
import aws.sdk.kotlin.services.cloudformation.model.PublisherStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribePublisherOperationDeserializer: HttpDeserialize<DescribePublisherResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePublisherResponse {
        if (!response.status.isSuccess()) {
            throwDescribePublisherError(context, response)
        }
        val builder = DescribePublisherResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePublisherOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePublisherError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePublisherOperationBody(builder: DescribePublisherResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribePublisherResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribePublisherResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribePublisher response")
    }
    // end unwrap response wrapper

    val IDENTITYPROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("IdentityProvider"))
    val PUBLISHERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PublisherId"))
    val PUBLISHERPROFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PublisherProfile"))
    val PUBLISHERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("PublisherStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("DescribePublisherResult"))
        field(IDENTITYPROVIDER_DESCRIPTOR)
        field(PUBLISHERID_DESCRIPTOR)
        field(PUBLISHERPROFILE_DESCRIPTOR)
        field(PUBLISHERSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IDENTITYPROVIDER_DESCRIPTOR.index -> builder.identityProvider = deserializeString().let { IdentityProvider.fromValue(it) }
                PUBLISHERID_DESCRIPTOR.index -> builder.publisherId = deserializeString()
                PUBLISHERPROFILE_DESCRIPTOR.index -> builder.publisherProfile = deserializeString()
                PUBLISHERSTATUS_DESCRIPTOR.index -> builder.publisherStatus = deserializeString().let { PublisherStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
