// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.AutoDeployment
import aws.sdk.kotlin.services.cloudformation.model.CallAs
import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.CreateStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.ManagedExecution
import aws.sdk.kotlin.services.cloudformation.model.Parameter
import aws.sdk.kotlin.services.cloudformation.model.PermissionModels
import aws.sdk.kotlin.services.cloudformation.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateStackSetOperationSerializer: HttpSerialize<CreateStackSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateStackSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateStackSetOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateStackSetOperationBody(context: ExecutionContext, input: CreateStackSetRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ADMINISTRATIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AdministrationRoleARN"))
    val AUTODEPLOYMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("AutoDeployment"))
    val CALLAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("CallAs"))
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Capabilities"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientRequestToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val EXECUTIONROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ExecutionRoleName"))
    val MANAGEDEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ManagedExecution"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Parameters"))
    val PERMISSIONMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("PermissionModel"))
    val STACKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackId"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackSetName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateBody"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateURL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateStackSetInput"))
        trait(QueryLiteral("Action", "CreateStackSet"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(ADMINISTRATIONROLEARN_DESCRIPTOR)
        field(AUTODEPLOYMENT_DESCRIPTOR)
        field(CALLAS_DESCRIPTOR)
        field(CAPABILITIES_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXECUTIONROLENAME_DESCRIPTOR)
        field(MANAGEDEXECUTION_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PERMISSIONMODEL_DESCRIPTOR)
        field(STACKID_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.administrationRoleArn?.let { field(ADMINISTRATIONROLEARN_DESCRIPTOR, it) }
        input.autoDeployment?.let { field(AUTODEPLOYMENT_DESCRIPTOR, it, ::serializeAutoDeploymentDocument) }
        input.callAs?.let { field(CALLAS_DESCRIPTOR, it.value) }
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0.value)
                }
            }
        }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.executionRoleName?.let { field(EXECUTIONROLENAME_DESCRIPTOR, it) }
        input.managedExecution?.let { field(MANAGEDEXECUTION_DESCRIPTOR, it, ::serializeManagedExecutionDocument) }
        if (input.parameters != null) {
            listField(PARAMETERS_DESCRIPTOR) {
                for (el0 in input.parameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeParameterDocument))
                }
            }
        }
        input.permissionModel?.let { field(PERMISSIONMODEL_DESCRIPTOR, it.value) }
        input.stackId?.let { field(STACKID_DESCRIPTOR, it) }
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.templateBody?.let { field(TEMPLATEBODY_DESCRIPTOR, it) }
        input.templateUrl?.let { field(TEMPLATEURL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
