// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetType
import aws.sdk.kotlin.services.cloudformation.model.CreateChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.Parameter
import aws.sdk.kotlin.services.cloudformation.model.ResourceToImport
import aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration
import aws.sdk.kotlin.services.cloudformation.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateChangeSetOperationSerializer: HttpSerialize<CreateChangeSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateChangeSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateChangeSetOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateChangeSetOperationBody(context: ExecutionContext, input: CreateChangeSetRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Capabilities"))
    val CHANGESETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ChangeSetName"))
    val CHANGESETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("ChangeSetType"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val INCLUDENESTEDSTACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("IncludeNestedStacks"))
    val NOTIFICATIONARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("NotificationARNs"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Parameters"))
    val RESOURCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ResourceTypes"))
    val RESOURCESTOIMPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ResourcesToImport"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleARN"))
    val ROLLBACKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("RollbackConfiguration"))
    val STACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateBody"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TemplateURL"))
    val USEPREVIOUSTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("UsePreviousTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateChangeSetInput"))
        trait(QueryLiteral("Action", "CreateChangeSet"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(CAPABILITIES_DESCRIPTOR)
        field(CHANGESETNAME_DESCRIPTOR)
        field(CHANGESETTYPE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INCLUDENESTEDSTACKS_DESCRIPTOR)
        field(NOTIFICATIONARNS_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(RESOURCETYPES_DESCRIPTOR)
        field(RESOURCESTOIMPORT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(ROLLBACKCONFIGURATION_DESCRIPTOR)
        field(STACKNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
        field(USEPREVIOUSTEMPLATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0.value)
                }
            }
        }
        input.changeSetName?.let { field(CHANGESETNAME_DESCRIPTOR, it) }
        input.changeSetType?.let { field(CHANGESETTYPE_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.includeNestedStacks?.let { field(INCLUDENESTEDSTACKS_DESCRIPTOR, it) }
        if (input.notificationArNs != null) {
            listField(NOTIFICATIONARNS_DESCRIPTOR) {
                for (el0 in input.notificationArNs) {
                    serializeString(el0)
                }
            }
        }
        if (input.parameters != null) {
            listField(PARAMETERS_DESCRIPTOR) {
                for (el0 in input.parameters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeParameterDocument))
                }
            }
        }
        if (input.resourceTypes != null) {
            listField(RESOURCETYPES_DESCRIPTOR) {
                for (el0 in input.resourceTypes) {
                    serializeString(el0)
                }
            }
        }
        if (input.resourcesToImport != null) {
            listField(RESOURCESTOIMPORT_DESCRIPTOR) {
                for (el0 in input.resourcesToImport) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourceToImportDocument))
                }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.rollbackConfiguration?.let { field(ROLLBACKCONFIGURATION_DESCRIPTOR, it, ::serializeRollbackConfigurationDocument) }
        input.stackName?.let { field(STACKNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.templateBody?.let { field(TEMPLATEBODY_DESCRIPTOR, it) }
        input.templateUrl?.let { field(TEMPLATEURL_DESCRIPTOR, it) }
        input.usePreviousTemplate?.let { field(USEPREVIOUSTEMPLATE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
