// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure that contains information about a stack set operation.
 */
public class StackSetOperation private constructor(builder: Builder) {
    /**
     * The type of stack set operation: `CREATE`, `UPDATE`, or `DELETE`. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, in addition to *all* associated stack set instances.
     */
    public val action: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction? = builder.action
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
     *
     * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see [Define Permissions for Multiple Administrators](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
     */
    public val administrationRoleArn: kotlin.String? = builder.administrationRoleArn
    /**
     * The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * &#91;Service-managed permissions&#93; The Organizations accounts affected by the stack operation.
     */
    public val deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = builder.deploymentTargets
    /**
     * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.
     */
    public val endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimestamp
    /**
     * The name of the IAM execution role used to create or update the stack set.
     *
     * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * The unique ID of a stack set operation.
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * The preferences for how CloudFormation performs this stack set operation.
     */
    public val operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = builder.operationPreferences
    /**
     * For stack set operations of action type `DELETE`, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an existing, saved stack to a new stack set.
     */
    public val retainStacks: kotlin.Boolean? = builder.retainStacks
    /**
     * Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.
     *
     * This information will only be present for stack set operations whose `Action` type is `DETECT_DRIFT`.
     *
     * For more information, see [Detecting Unmanaged Changes in Stack Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html) in the CloudFormation User Guide.
     */
    public val stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = builder.stackSetDriftDetectionDetails
    /**
     * The ID of the stack set.
     */
    public val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The status of the operation.
     * + `FAILED`: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to `FAILED`. This in turn sets the status of the operation as a whole to `FAILED`, and CloudFormation cancels the operation in any remaining Regions.
     * + `QUEUED`: &#91;Service-managed permissions&#93; For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the [stack set operation status codes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes) in the CloudFormation User Guide.
     * + `RUNNING`: The operation is currently being performed.
     * + `STOPPED`: The user has canceled the operation.
     * + `STOPPING`: The operation is in the process of stopping, at user request.
     * + `SUCCEEDED`: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus? = builder.status
    /**
     * Detailed information about the StackSet operation.
     */
    public val statusDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatusDetails? = builder.statusDetails
    /**
     * The status of the operation in details.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetOperation(")
        append("action=$action,")
        append("administrationRoleArn=$administrationRoleArn,")
        append("creationTimestamp=$creationTimestamp,")
        append("deploymentTargets=$deploymentTargets,")
        append("endTimestamp=$endTimestamp,")
        append("executionRoleName=$executionRoleName,")
        append("operationId=$operationId,")
        append("operationPreferences=$operationPreferences,")
        append("retainStacks=$retainStacks,")
        append("stackSetDriftDetectionDetails=$stackSetDriftDetectionDetails,")
        append("stackSetId=$stackSetId,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (administrationRoleArn?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (deploymentTargets?.hashCode() ?: 0)
        result = 31 * result + (endTimestamp?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (operationPreferences?.hashCode() ?: 0)
        result = 31 * result + (retainStacks?.hashCode() ?: 0)
        result = 31 * result + (stackSetDriftDetectionDetails?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetOperation

        if (action != other.action) return false
        if (administrationRoleArn != other.administrationRoleArn) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (deploymentTargets != other.deploymentTargets) return false
        if (endTimestamp != other.endTimestamp) return false
        if (executionRoleName != other.executionRoleName) return false
        if (operationId != other.operationId) return false
        if (operationPreferences != other.operationPreferences) return false
        if (retainStacks != other.retainStacks) return false
        if (stackSetDriftDetectionDetails != other.stackSetDriftDetectionDetails) return false
        if (stackSetId != other.stackSetId) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of stack set operation: `CREATE`, `UPDATE`, or `DELETE`. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, in addition to *all* associated stack set instances.
         */
        public var action: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to perform this stack set operation.
         *
         * Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see [Define Permissions for Multiple Administrators](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html) in the *CloudFormation User Guide*.
         */
        public var administrationRoleArn: kotlin.String? = null
        /**
         * The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * &#91;Service-managed permissions&#93; The Organizations accounts affected by the stack operation.
         */
        public var deploymentTargets: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets? = null
        /**
         * The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn't necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.
         */
        public var endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the IAM execution role used to create or update the stack set.
         *
         * Use customized execution roles to control which stack resources users and groups can include in their stack sets.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * The unique ID of a stack set operation.
         */
        public var operationId: kotlin.String? = null
        /**
         * The preferences for how CloudFormation performs this stack set operation.
         */
        public var operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = null
        /**
         * For stack set operations of action type `DELETE`, specifies whether to remove the stack instances from the specified stack set, but doesn't delete the stacks. You can't re-associate a retained stack, or add an existing, saved stack to a new stack set.
         */
        public var retainStacks: kotlin.Boolean? = null
        /**
         * Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.
         *
         * This information will only be present for stack set operations whose `Action` type is `DETECT_DRIFT`.
         *
         * For more information, see [Detecting Unmanaged Changes in Stack Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html) in the CloudFormation User Guide.
         */
        public var stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = null
        /**
         * The ID of the stack set.
         */
        public var stackSetId: kotlin.String? = null
        /**
         * The status of the operation.
         * + `FAILED`: The operation exceeded the specified failure tolerance. The failure tolerance value that you've set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to `FAILED`. This in turn sets the status of the operation as a whole to `FAILED`, and CloudFormation cancels the operation in any remaining Regions.
         * + `QUEUED`: &#91;Service-managed permissions&#93; For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the [stack set operation status codes](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes) in the CloudFormation User Guide.
         * + `RUNNING`: The operation is currently being performed.
         * + `STOPPED`: The user has canceled the operation.
         * + `STOPPING`: The operation is in the process of stopping, at user request.
         * + `SUCCEEDED`: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus? = null
        /**
         * Detailed information about the StackSet operation.
         */
        public var statusDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatusDetails? = null
        /**
         * The status of the operation in details.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetOperation) : this() {
            this.action = x.action
            this.administrationRoleArn = x.administrationRoleArn
            this.creationTimestamp = x.creationTimestamp
            this.deploymentTargets = x.deploymentTargets
            this.endTimestamp = x.endTimestamp
            this.executionRoleName = x.executionRoleName
            this.operationId = x.operationId
            this.operationPreferences = x.operationPreferences
            this.retainStacks = x.retainStacks
            this.stackSetDriftDetectionDetails = x.stackSetDriftDetectionDetails
            this.stackSetId = x.stackSetId
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetOperation = StackSetOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets] inside the given [block]
         */
        public fun deploymentTargets(block: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.Builder.() -> kotlin.Unit) {
            this.deploymentTargets = aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences] inside the given [block]
         */
        public fun operationPreferences(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.Builder.() -> kotlin.Unit) {
            this.operationPreferences = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails] inside the given [block]
         */
        public fun stackSetDriftDetectionDetails(block: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.Builder.() -> kotlin.Unit) {
            this.stackSetDriftDetectionDetails = aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatusDetails] inside the given [block]
         */
        public fun statusDetails(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatusDetails.Builder.() -> kotlin.Unit) {
            this.statusDetails = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatusDetails.invoke(block)
        }
    }
}
