// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The output for the DescribeChangeSet action.
 */
public class DescribeChangeSetResponse private constructor(builder: Builder) {
    /**
     * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was created.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The Amazon Resource Name (ARN) of the change set.
     */
    public val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * The name of the change set.
     */
    public val changeSetName: kotlin.String? = builder.changeSetName
    /**
     * A list of `Change` structures that describes the resources CloudFormation changes if you execute the change set.
     */
    public val changes: List<Change>? = builder.changes
    /**
     * The start time when the change set was created, in UTC.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the change set.
     */
    public val description: kotlin.String? = builder.description
    /**
     * If the change set execution status is `AVAILABLE`, you can execute the change set. If you can't execute the change set, the status indicates why. For example, a change set might be in an `UNAVAILABLE` state because CloudFormation is still creating it or in an `OBSOLETE` state because the stack was already updated.
     */
    public val executionStatus: aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus? = builder.executionStatus
    /**
     * Verifies if `IncludeNestedStacks` is set to `True`.
     */
    public val includeNestedStacks: kotlin.Boolean? = builder.includeNestedStacks
    /**
     * If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional page, this value is null.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack if you execute the change set.
     */
    public val notificationArNs: List<String>? = builder.notificationArNs
    /**
     * A list of `Parameter` structures that describes the input parameters and their values used to create the change set. For more information, see the [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html) data type.
     */
    public val parameters: List<Parameter>? = builder.parameters
    /**
     * Specifies the change set ID of the parent change set in the current nested change set hierarchy.
     */
    public val parentChangeSetId: kotlin.String? = builder.parentChangeSetId
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
     */
    public val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * Specifies the change set ID of the root change set in the current nested change set hierarchy.
     */
    public val rootChangeSetId: kotlin.String? = builder.rootChangeSetId
    /**
     * The Amazon Resource Name (ARN) of the stack that's associated with the change set.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The name of the stack that's associated with the change set.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * The current status of the change set, such as `CREATE_IN_PROGRESS`, `CREATE_COMPLETE`, or `FAILED`.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus? = builder.status
    /**
     * A description of the change set's status. For example, if your attempt to create a change set failed, CloudFormation shows the error message.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * If you execute the change set, the tags that will be associated with the stack.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeChangeSetResponse(")
        append("capabilities=$capabilities,")
        append("changeSetId=$changeSetId,")
        append("changeSetName=$changeSetName,")
        append("changes=$changes,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("executionStatus=$executionStatus,")
        append("includeNestedStacks=$includeNestedStacks,")
        append("nextToken=$nextToken,")
        append("notificationArNs=$notificationArNs,")
        append("parameters=$parameters,")
        append("parentChangeSetId=$parentChangeSetId,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("rootChangeSetId=$rootChangeSetId,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (changeSetId?.hashCode() ?: 0)
        result = 31 * result + (changeSetName?.hashCode() ?: 0)
        result = 31 * result + (changes?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionStatus?.hashCode() ?: 0)
        result = 31 * result + (includeNestedStacks?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (notificationArNs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (parentChangeSetId?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (rootChangeSetId?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeChangeSetResponse

        if (capabilities != other.capabilities) return false
        if (changeSetId != other.changeSetId) return false
        if (changeSetName != other.changeSetName) return false
        if (changes != other.changes) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (executionStatus != other.executionStatus) return false
        if (includeNestedStacks != other.includeNestedStacks) return false
        if (nextToken != other.nextToken) return false
        if (notificationArNs != other.notificationArNs) return false
        if (parameters != other.parameters) return false
        if (parentChangeSetId != other.parentChangeSetId) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (rootChangeSetId != other.rootChangeSetId) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was created.
         */
        public var capabilities: List<Capability>? = null
        /**
         * The Amazon Resource Name (ARN) of the change set.
         */
        public var changeSetId: kotlin.String? = null
        /**
         * The name of the change set.
         */
        public var changeSetName: kotlin.String? = null
        /**
         * A list of `Change` structures that describes the resources CloudFormation changes if you execute the change set.
         */
        public var changes: List<Change>? = null
        /**
         * The start time when the change set was created, in UTC.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the change set.
         */
        public var description: kotlin.String? = null
        /**
         * If the change set execution status is `AVAILABLE`, you can execute the change set. If you can't execute the change set, the status indicates why. For example, a change set might be in an `UNAVAILABLE` state because CloudFormation is still creating it or in an `OBSOLETE` state because the stack was already updated.
         */
        public var executionStatus: aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus? = null
        /**
         * Verifies if `IncludeNestedStacks` is set to `True`.
         */
        public var includeNestedStacks: kotlin.Boolean? = null
        /**
         * If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional page, this value is null.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack if you execute the change set.
         */
        public var notificationArNs: List<String>? = null
        /**
         * A list of `Parameter` structures that describes the input parameters and their values used to create the change set. For more information, see the [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html) data type.
         */
        public var parameters: List<Parameter>? = null
        /**
         * Specifies the change set ID of the parent change set in the current nested change set hierarchy.
         */
        public var parentChangeSetId: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.
         */
        public var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * Specifies the change set ID of the root change set in the current nested change set hierarchy.
         */
        public var rootChangeSetId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the stack that's associated with the change set.
         */
        public var stackId: kotlin.String? = null
        /**
         * The name of the stack that's associated with the change set.
         */
        public var stackName: kotlin.String? = null
        /**
         * The current status of the change set, such as `CREATE_IN_PROGRESS`, `CREATE_COMPLETE`, or `FAILED`.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus? = null
        /**
         * A description of the change set's status. For example, if your attempt to create a change set failed, CloudFormation shows the error message.
         */
        public var statusReason: kotlin.String? = null
        /**
         * If you execute the change set, the tags that will be associated with the stack.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse) : this() {
            this.capabilities = x.capabilities
            this.changeSetId = x.changeSetId
            this.changeSetName = x.changeSetName
            this.changes = x.changes
            this.creationTime = x.creationTime
            this.description = x.description
            this.executionStatus = x.executionStatus
            this.includeNestedStacks = x.includeNestedStacks
            this.nextToken = x.nextToken
            this.notificationArNs = x.notificationArNs
            this.parameters = x.parameters
            this.parentChangeSetId = x.parentChangeSetId
            this.rollbackConfiguration = x.rollbackConfiguration
            this.rootChangeSetId = x.rootChangeSetId
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse = DescribeChangeSetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        public fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }
    }
}
