// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for DeleteStack action.
 */
public class DeleteStackRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for this `DeleteStack` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to delete a stack with the same name. You might retry `DeleteStack` requests to ensure that CloudFormation successfully received them.
     *
     * All events initiated by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a `CreateStack` operation with the token `token1`, then all the `StackEvents` generated by that operation will have `ClientRequestToken` set as `token1`.
     *
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format *Console-StackOperation-ID*, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * For stacks in the `DELETE_FAILED` state, a list of resource logical IDs that are associated with the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't delete the retained resources.
     *
     * Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you want to delete the stack.
     */
    public val retainResources: List<String>? = builder.retainResources
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFormation assumes to delete the stack. CloudFormation uses the role's credentials to make calls on your behalf.
     *
     * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no role is available, CloudFormation uses a temporary session that's generated from your user credentials.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name or the unique stack ID that's associated with the stack.
     */
    public val stackName: kotlin.String? = builder.stackName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteStackRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("retainResources=$retainResources,")
        append("roleArn=$roleArn,")
        append("stackName=$stackName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (retainResources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteStackRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (retainResources != other.retainResources) return false
        if (roleArn != other.roleArn) return false
        if (stackName != other.stackName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for this `DeleteStack` request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to delete a stack with the same name. You might retry `DeleteStack` requests to ensure that CloudFormation successfully received them.
         *
         * All events initiated by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a `CreateStack` operation with the token `token1`, then all the `StackEvents` generated by that operation will have `ClientRequestToken` set as `token1`.
         *
         * In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format *Console-StackOperation-ID*, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * For stacks in the `DELETE_FAILED` state, a list of resource logical IDs that are associated with the resources you want to retain. During deletion, CloudFormation deletes the stack but doesn't delete the retained resources.
         *
         * Retaining resources is useful when you can't delete a resource, such as a non-empty S3 bucket, but you want to delete the stack.
         */
        public var retainResources: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFormation assumes to delete the stack. CloudFormation uses the role's credentials to make calls on your behalf.
         *
         * If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no role is available, CloudFormation uses a temporary session that's generated from your user credentials.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name or the unique stack ID that's associated with the stack.
         */
        public var stackName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.retainResources = x.retainResources
            this.roleArn = x.roleArn
            this.stackName = x.stackName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DeleteStackRequest = DeleteStackRequest(this)
    }
}
