// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.services.cloudformation.model.CallAs
import aws.sdk.kotlin.services.cloudformation.model.ImportStacksToStackSetRequest
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportStacksToStackSetOperationSerializer: HttpSerialize<ImportStacksToStackSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportStacksToStackSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeImportStacksToStackSetOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeImportStacksToStackSetOperationBody(context: ExecutionContext, input: ImportStacksToStackSetRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CALLAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CallAs"))
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OperationId"))
    val OPERATIONPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("OperationPreferences"))
    val ORGANIZATIONALUNITIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("OrganizationalUnitIds"))
    val STACKIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("StackIds"))
    val STACKIDSURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackIdsUrl"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StackSetName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ImportStacksToStackSetInput"))
        trait(QueryLiteral("Action", "ImportStacksToStackSet"))
        trait(QueryLiteral("Version", "2010-05-15"))
        field(CALLAS_DESCRIPTOR)
        field(OPERATIONID_DESCRIPTOR)
        field(OPERATIONPREFERENCES_DESCRIPTOR)
        field(ORGANIZATIONALUNITIDS_DESCRIPTOR)
        field(STACKIDS_DESCRIPTOR)
        field(STACKIDSURL_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.callAs?.let { field(CALLAS_DESCRIPTOR, it.value) }
        input.operationId?.let { field(OPERATIONID_DESCRIPTOR, it) } ?: field(OPERATIONID_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.operationPreferences?.let { field(OPERATIONPREFERENCES_DESCRIPTOR, it, ::serializeStackSetOperationPreferencesDocument) }
        if (input.organizationalUnitIds != null) {
            listField(ORGANIZATIONALUNITIDS_DESCRIPTOR) {
                for (el0 in input.organizationalUnitIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.stackIds != null) {
            listField(STACKIDS_DESCRIPTOR) {
                for (el0 in input.stackIds) {
                    serializeString(el0)
                }
            }
        }
        input.stackIdsUrl?.let { field(STACKIDSURL_DESCRIPTOR, it) }
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
