// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DeprecatedStatus
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.LoggingConfig
import aws.sdk.kotlin.services.cloudformation.model.ProvisioningType
import aws.sdk.kotlin.services.cloudformation.model.RegistryType
import aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType
import aws.sdk.kotlin.services.cloudformation.model.TypeTestsStatus
import aws.sdk.kotlin.services.cloudformation.model.Visibility
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeTypeOperationDeserializer: HttpDeserialize<DescribeTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTypeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTypeError(context, response)
        }
        val builder = DescribeTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedResponse)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTypeOperationBody(builder: DescribeTypeResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeTypeResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeTypeResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeType response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Arn"))
    val AUTOUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AutoUpdate"))
    val CONFIGURATIONSCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ConfigurationSchema"))
    val DEFAULTVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DefaultVersionId"))
    val DEPRECATEDSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DeprecatedStatus"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val DOCUMENTATIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DocumentationUrl"))
    val EXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ExecutionRoleArn"))
    val ISACTIVATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsActivated"))
    val ISDEFAULTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("IsDefaultVersion"))
    val LASTUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("LastUpdated"))
    val LATESTPUBLICVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("LatestPublicVersion"))
    val LOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("LoggingConfig"))
    val ORIGINALTYPEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("OriginalTypeArn"))
    val ORIGINALTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("OriginalTypeName"))
    val PROVISIONINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ProvisioningType"))
    val PUBLICVERSIONNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PublicVersionNumber"))
    val PUBLISHERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PublisherId"))
    val REQUIREDACTIVATEDTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("RequiredActivatedTypes"))
    val SCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Schema"))
    val SOURCEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SourceUrl"))
    val TIMECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("TimeCreated"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Type"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TypeName"))
    val TYPETESTSSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TypeTestsStatus"))
    val TYPETESTSSTATUSDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TypeTestsStatusDescription"))
    val VISIBILITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Visibility"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://cloudformation.amazonaws.com/doc/2010-05-15/"))
        trait(XmlSerialName("DescribeTypeResult"))
        field(ARN_DESCRIPTOR)
        field(AUTOUPDATE_DESCRIPTOR)
        field(CONFIGURATIONSCHEMA_DESCRIPTOR)
        field(DEFAULTVERSIONID_DESCRIPTOR)
        field(DEPRECATEDSTATUS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENTATIONURL_DESCRIPTOR)
        field(EXECUTIONROLEARN_DESCRIPTOR)
        field(ISACTIVATED_DESCRIPTOR)
        field(ISDEFAULTVERSION_DESCRIPTOR)
        field(LASTUPDATED_DESCRIPTOR)
        field(LATESTPUBLICVERSION_DESCRIPTOR)
        field(LOGGINGCONFIG_DESCRIPTOR)
        field(ORIGINALTYPEARN_DESCRIPTOR)
        field(ORIGINALTYPENAME_DESCRIPTOR)
        field(PROVISIONINGTYPE_DESCRIPTOR)
        field(PUBLICVERSIONNUMBER_DESCRIPTOR)
        field(PUBLISHERID_DESCRIPTOR)
        field(REQUIREDACTIVATEDTYPES_DESCRIPTOR)
        field(SCHEMA_DESCRIPTOR)
        field(SOURCEURL_DESCRIPTOR)
        field(TIMECREATED_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
        field(TYPETESTSSTATUS_DESCRIPTOR)
        field(TYPETESTSSTATUSDESCRIPTION_DESCRIPTOR)
        field(VISIBILITY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AUTOUPDATE_DESCRIPTOR.index -> builder.autoUpdate = deserializeBoolean()
                CONFIGURATIONSCHEMA_DESCRIPTOR.index -> builder.configurationSchema = deserializeString()
                DEFAULTVERSIONID_DESCRIPTOR.index -> builder.defaultVersionId = deserializeString()
                DEPRECATEDSTATUS_DESCRIPTOR.index -> builder.deprecatedStatus = deserializeString().let { DeprecatedStatus.fromValue(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOCUMENTATIONURL_DESCRIPTOR.index -> builder.documentationUrl = deserializeString()
                EXECUTIONROLEARN_DESCRIPTOR.index -> builder.executionRoleArn = deserializeString()
                ISACTIVATED_DESCRIPTOR.index -> builder.isActivated = deserializeBoolean()
                ISDEFAULTVERSION_DESCRIPTOR.index -> builder.isDefaultVersion = deserializeBoolean()
                LASTUPDATED_DESCRIPTOR.index -> builder.lastUpdated = deserializeString().let { Instant.fromIso8601(it) }
                LATESTPUBLICVERSION_DESCRIPTOR.index -> builder.latestPublicVersion = deserializeString()
                LOGGINGCONFIG_DESCRIPTOR.index -> builder.loggingConfig = deserializeLoggingConfigDocument(deserializer)
                ORIGINALTYPEARN_DESCRIPTOR.index -> builder.originalTypeArn = deserializeString()
                ORIGINALTYPENAME_DESCRIPTOR.index -> builder.originalTypeName = deserializeString()
                PROVISIONINGTYPE_DESCRIPTOR.index -> builder.provisioningType = deserializeString().let { ProvisioningType.fromValue(it) }
                PUBLICVERSIONNUMBER_DESCRIPTOR.index -> builder.publicVersionNumber = deserializeString()
                PUBLISHERID_DESCRIPTOR.index -> builder.publisherId = deserializeString()
                REQUIREDACTIVATEDTYPES_DESCRIPTOR.index -> builder.requiredActivatedTypes =
                    deserializer.deserializeList(REQUIREDACTIVATEDTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<RequiredActivatedType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRequiredActivatedTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCHEMA_DESCRIPTOR.index -> builder.schema = deserializeString()
                SOURCEURL_DESCRIPTOR.index -> builder.sourceUrl = deserializeString()
                TIMECREATED_DESCRIPTOR.index -> builder.timeCreated = deserializeString().let { Instant.fromIso8601(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { RegistryType.fromValue(it) }
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                TYPETESTSSTATUS_DESCRIPTOR.index -> builder.typeTestsStatus = deserializeString().let { TypeTestsStatus.fromValue(it) }
                TYPETESTSSTATUSDESCRIPTION_DESCRIPTOR.index -> builder.typeTestsStatusDescription = deserializeString()
                VISIBILITY_DESCRIPTOR.index -> builder.visibility = deserializeString().let { Visibility.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
