// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.paginators

import aws.sdk.kotlin.services.cloudformation.CloudFormationClient
import aws.sdk.kotlin.services.cloudformation.model.AccountLimit
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.Export
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListExportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListExportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypesResponse
import aws.sdk.kotlin.services.cloudformation.model.Stack
import aws.sdk.kotlin.services.cloudformation.model.StackEvent
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceSummary
import aws.sdk.kotlin.services.cloudformation.model.StackResourceSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSummary
import aws.sdk.kotlin.services.cloudformation.model.TypeSummary
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccountLimitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
fun CloudFormationClient.describeAccountLimitsPaginated(initialRequest: DescribeAccountLimitsRequest): Flow<DescribeAccountLimitsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccountLimitsPaginated.describeAccountLimits(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
fun CloudFormationClient.describeAccountLimitsPaginated(block: DescribeAccountLimitsRequest.Builder.() -> Unit): Flow<DescribeAccountLimitsResponse> =
    describeAccountLimitsPaginated(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAccountLimitsPaginated]
 * to access the nested member [AccountLimit]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountLimit]
 */
@JvmName("describeAccountLimitsResponseAccountLimit")
fun Flow<DescribeAccountLimitsResponse>.accountLimits(): Flow<AccountLimit> =
    transform() { response ->
        response.accountLimits?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStackEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStackEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackEventsResponse]
 */
fun CloudFormationClient.describeStackEventsPaginated(initialRequest: DescribeStackEventsRequest): Flow<DescribeStackEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStackEventsPaginated.describeStackEvents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStackEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackEventsResponse]
 */
fun CloudFormationClient.describeStackEventsPaginated(block: DescribeStackEventsRequest.Builder.() -> Unit): Flow<DescribeStackEventsResponse> =
    describeStackEventsPaginated(DescribeStackEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStackEventsPaginated]
 * to access the nested member [StackEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackEvent]
 */
@JvmName("describeStackEventsResponseStackEvent")
fun Flow<DescribeStackEventsResponse>.stackEvents(): Flow<StackEvent> =
    transform() { response ->
        response.stackEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStackResourceDriftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStackResourceDriftsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackResourceDriftsResponse]
 */
fun CloudFormationClient.describeStackResourceDriftsPaginated(initialRequest: DescribeStackResourceDriftsRequest): Flow<DescribeStackResourceDriftsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStackResourceDriftsPaginated.describeStackResourceDrifts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStackResourceDriftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackResourceDriftsResponse]
 */
fun CloudFormationClient.describeStackResourceDriftsPaginated(block: DescribeStackResourceDriftsRequest.Builder.() -> Unit): Flow<DescribeStackResourceDriftsResponse> =
    describeStackResourceDriftsPaginated(DescribeStackResourceDriftsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStacksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStacksResponse]
 */
fun CloudFormationClient.describeStacksPaginated(initialRequest: DescribeStacksRequest): Flow<DescribeStacksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStacksPaginated.describeStacks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStacksResponse]
 */
fun CloudFormationClient.describeStacksPaginated(block: DescribeStacksRequest.Builder.() -> Unit): Flow<DescribeStacksResponse> =
    describeStacksPaginated(DescribeStacksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStacksPaginated]
 * to access the nested member [Stack]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Stack]
 */
@JvmName("describeStacksResponseStack")
fun Flow<DescribeStacksResponse>.stacks(): Flow<Stack> =
    transform() { response ->
        response.stacks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChangeSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChangeSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChangeSetsResponse]
 */
fun CloudFormationClient.listChangeSetsPaginated(initialRequest: ListChangeSetsRequest): Flow<ListChangeSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChangeSetsPaginated.listChangeSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListChangeSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChangeSetsResponse]
 */
fun CloudFormationClient.listChangeSetsPaginated(block: ListChangeSetsRequest.Builder.() -> Unit): Flow<ListChangeSetsResponse> =
    listChangeSetsPaginated(ListChangeSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChangeSetsPaginated]
 * to access the nested member [ChangeSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChangeSetSummary]
 */
@JvmName("listChangeSetsResponseChangeSetSummary")
fun Flow<ListChangeSetsResponse>.summaries(): Flow<ChangeSetSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
fun CloudFormationClient.listExportsPaginated(initialRequest: ListExportsRequest): Flow<ListExportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExportsPaginated.listExports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
fun CloudFormationClient.listExportsPaginated(block: ListExportsRequest.Builder.() -> Unit): Flow<ListExportsResponse> =
    listExportsPaginated(ListExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExportsPaginated]
 * to access the nested member [Export]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Export]
 */
@JvmName("listExportsResponseExport")
fun Flow<ListExportsResponse>.exports(): Flow<Export> =
    transform() { response ->
        response.exports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
fun CloudFormationClient.listImportsPaginated(initialRequest: ListImportsRequest): Flow<ListImportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportsPaginated.listImports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
fun CloudFormationClient.listImportsPaginated(block: ListImportsRequest.Builder.() -> Unit): Flow<ListImportsResponse> =
    listImportsPaginated(ListImportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportsPaginated]
 * to access the nested member [StackName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackName]
 */
@JvmName("listImportsResponseStackName")
fun Flow<ListImportsResponse>.imports(): Flow<String> =
    transform() { response ->
        response.imports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackInstancesResponse]
 */
fun CloudFormationClient.listStackInstancesPaginated(initialRequest: ListStackInstancesRequest): Flow<ListStackInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackInstancesPaginated.listStackInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStackInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackInstancesResponse]
 */
fun CloudFormationClient.listStackInstancesPaginated(block: ListStackInstancesRequest.Builder.() -> Unit): Flow<ListStackInstancesResponse> =
    listStackInstancesPaginated(ListStackInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackInstancesPaginated]
 * to access the nested member [StackInstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackInstanceSummary]
 */
@JvmName("listStackInstancesResponseStackInstanceSummary")
fun Flow<ListStackInstancesResponse>.summaries(): Flow<StackInstanceSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackResourcesResponse]
 */
fun CloudFormationClient.listStackResourcesPaginated(initialRequest: ListStackResourcesRequest): Flow<ListStackResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackResourcesPaginated.listStackResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStackResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackResourcesResponse]
 */
fun CloudFormationClient.listStackResourcesPaginated(block: ListStackResourcesRequest.Builder.() -> Unit): Flow<ListStackResourcesResponse> =
    listStackResourcesPaginated(ListStackResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackResourcesPaginated]
 * to access the nested member [StackResourceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackResourceSummary]
 */
@JvmName("listStackResourcesResponseStackResourceSummary")
fun Flow<ListStackResourcesResponse>.stackResourceSummaries(): Flow<StackResourceSummary> =
    transform() { response ->
        response.stackResourceSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStacksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStacksResponse]
 */
fun CloudFormationClient.listStacksPaginated(initialRequest: ListStacksRequest): Flow<ListStacksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStacksPaginated.listStacks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStacksResponse]
 */
fun CloudFormationClient.listStacksPaginated(block: ListStacksRequest.Builder.() -> Unit): Flow<ListStacksResponse> =
    listStacksPaginated(ListStacksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStacksPaginated]
 * to access the nested member [StackSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSummary]
 */
@JvmName("listStacksResponseStackSummary")
fun Flow<ListStacksResponse>.stackSummaries(): Flow<StackSummary> =
    transform() { response ->
        response.stackSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetOperationResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetOperationResultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationResultsResponse]
 */
fun CloudFormationClient.listStackSetOperationResultsPaginated(initialRequest: ListStackSetOperationResultsRequest): Flow<ListStackSetOperationResultsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetOperationResultsPaginated.listStackSetOperationResults(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetOperationResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationResultsResponse]
 */
fun CloudFormationClient.listStackSetOperationResultsPaginated(block: ListStackSetOperationResultsRequest.Builder.() -> Unit): Flow<ListStackSetOperationResultsResponse> =
    listStackSetOperationResultsPaginated(ListStackSetOperationResultsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetOperationResultsPaginated]
 * to access the nested member [StackSetOperationResultSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetOperationResultSummary]
 */
@JvmName("listStackSetOperationResultsResponseStackSetOperationResultSummary")
fun Flow<ListStackSetOperationResultsResponse>.summaries(): Flow<StackSetOperationResultSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationsResponse]
 */
fun CloudFormationClient.listStackSetOperationsPaginated(initialRequest: ListStackSetOperationsRequest): Flow<ListStackSetOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetOperationsPaginated.listStackSetOperations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationsResponse]
 */
fun CloudFormationClient.listStackSetOperationsPaginated(block: ListStackSetOperationsRequest.Builder.() -> Unit): Flow<ListStackSetOperationsResponse> =
    listStackSetOperationsPaginated(ListStackSetOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetOperationsPaginated]
 * to access the nested member [StackSetOperationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetOperationSummary]
 */
@JvmName("listStackSetOperationsResponseStackSetOperationSummary")
fun Flow<ListStackSetOperationsResponse>.summaries(): Flow<StackSetOperationSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetsResponse]
 */
fun CloudFormationClient.listStackSetsPaginated(initialRequest: ListStackSetsRequest): Flow<ListStackSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetsPaginated.listStackSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetsResponse]
 */
fun CloudFormationClient.listStackSetsPaginated(block: ListStackSetsRequest.Builder.() -> Unit): Flow<ListStackSetsResponse> =
    listStackSetsPaginated(ListStackSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetsPaginated]
 * to access the nested member [StackSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetSummary]
 */
@JvmName("listStackSetsResponseStackSetSummary")
fun Flow<ListStackSetsResponse>.summaries(): Flow<StackSetSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypeRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypeRegistrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeRegistrationsResponse]
 */
fun CloudFormationClient.listTypeRegistrationsPaginated(initialRequest: ListTypeRegistrationsRequest): Flow<ListTypeRegistrationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypeRegistrationsPaginated.listTypeRegistrations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTypeRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeRegistrationsResponse]
 */
fun CloudFormationClient.listTypeRegistrationsPaginated(block: ListTypeRegistrationsRequest.Builder.() -> Unit): Flow<ListTypeRegistrationsResponse> =
    listTypeRegistrationsPaginated(ListTypeRegistrationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
fun CloudFormationClient.listTypesPaginated(initialRequest: ListTypesRequest): Flow<ListTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypesPaginated.listTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
fun CloudFormationClient.listTypesPaginated(block: ListTypesRequest.Builder.() -> Unit): Flow<ListTypesResponse> =
    listTypesPaginated(ListTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTypesPaginated]
 * to access the nested member [TypeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TypeSummary]
 */
@JvmName("listTypesResponseTypeSummary")
fun Flow<ListTypesResponse>.typeSummaries(): Flow<TypeSummary> =
    transform() { response ->
        response.typeSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypeVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeVersionsResponse]
 */
fun CloudFormationClient.listTypeVersionsPaginated(initialRequest: ListTypeVersionsRequest): Flow<ListTypeVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypeVersionsPaginated.listTypeVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTypeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeVersionsResponse]
 */
fun CloudFormationClient.listTypeVersionsPaginated(block: ListTypeVersionsRequest.Builder.() -> Unit): Flow<ListTypeVersionsResponse> =
    listTypeVersionsPaginated(ListTypeVersionsRequest.Builder().apply(block).build())
