// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for an UpdateStack action.
 */
class UpdateStackRequest private constructor(builder: Builder) {
    /**
     * In some cases, you must explicitly acknowledge that your stack template contains certain
     * capabilities in order for CloudFormation to update the stack.
     *
     *
     *
     * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
     *
     * Some stack templates might include resources that can affect permissions in your
     * Amazon Web Services account; for example, by creating new Identity and Access Management
     * (IAM) users. For those stacks, you must explicitly acknowledge this
     * by specifying one of these capabilities.
     * The following IAM resources require you to specify either the
     * CAPABILITY_IAM or CAPABILITY_NAMED_IAM
     * capability.
     *
     *
     * If you have IAM resources, you can specify either
     * capability.
     *
     * If you have IAM resources with custom names, you
     * must specify CAPABILITY_NAMED_IAM.
     *
     * If you don't specify either of these capabilities, CloudFormation returns an
     * InsufficientCapabilities error.
     *
     *
     * If your stack template contains these resources, we recommend that you review all
     * permissions associated with them and edit their permissions if necessary.
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">AWS::IAM::UserToGroupAddition
     *
     *
     *
     * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.
     *
     *
     * CAPABILITY_AUTO_EXPAND
     *
     * Some template contain macros. Macros perform custom processing on templates; this
     * can include simple actions like find-and-replace operations, all the way to extensive
     * transformations of entire templates. Because of this, users typically create a change
     * set from the processed template, so that they can review the changes resulting from
     * the macros before actually updating the stack. If your stack template contains one or
     * more macros, and you choose to update a stack directly from the processed template,
     * without first reviewing the resulting changes in a change set, you must acknowledge
     * this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless transforms, which are macros hosted by CloudFormation.
     * If you want to update a stack from a stack template that contains macros
     * and nested stacks, you must update the stack directly from
     * the template using this capability.
     *
     * You should only update stacks directly from a stack template that contains
     * macros if you know what processing the macro performs.
     * Each macro relies on an underlying Lambda service function for
     * processing stack templates. Be aware that the Lambda function owner can update the
     * function operation without CloudFormation being notified.
     *
     * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
     * CloudFormation Macros to Perform Custom Processing on
     * Templates.
     */
    val capabilities: List<Capability>? = builder.capabilities
    /**
     * A unique identifier for this UpdateStack request. Specify this token if you
     * plan to retry requests so that CloudFormation knows that you're not attempting to
     * update a stack with the same name. You might retry UpdateStack requests to
     * ensure that CloudFormation successfully received them.
     * All events triggered by a given stack operation are assigned the same client request
     * token, which you can use to track operations. For example, if you execute a
     * CreateStack operation with the token token1, then all the
     * StackEvents generated by that operation will have
     * ClientRequestToken set as token1.
     * In the console, stack operations display the client request token on the Events tab.
     * Stack operations that are initiated from the console use the token format
     * Console-StackOperation-ID, which helps you easily identify the
     * stack operation . For example, if you create a stack using the console, each stack event
     * would be assigned the same token in the following format:
     * Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Preserve the state of previously provisioned resources when an operation fails.
     * Default: False
     */
    val disableRollback: kotlin.Boolean? = builder.disableRollback
    /**
     * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with the stack. Specify an empty list to remove all
     * notification topics.
     */
    val notificationArNs: List<String>? = builder.notificationArNs
    /**
     * A list of Parameter structures that specify input parameters for the stack.
     * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter data
     * type.
     */
    val parameters: List<Parameter>? = builder.parameters
    /**
     * The template resource types that you have permissions to work with for this update stack
     * action, such as AWS::EC2::Instance, AWS::EC2::*, or
     * Custom::MyCustomInstance.
     * If the list of resource types doesn't include a resource that you're updating, the stack
     * update fails. By default, CloudFormation grants permissions to all resource types.
     * Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management.
     */
    val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
     * that CloudFormation assumes to update the stack. CloudFormation uses the
     * role's credentials to make calls on your behalf. CloudFormation always uses this
     * role for all future operations on the stack. Provided that users have permission to operate
     * on the stack, CloudFormation uses this role even if the users don't have permission
     * to pass it. Ensure that the role grants least privilege.
     * If you don't specify a value, CloudFormation uses the role that was previously
     * associated with the stack. If no role is available, CloudFormation uses a temporary
     * session that is generated from your user credentials.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The rollback triggers for CloudFormation to monitor during stack creation and
     * updating operations, and for the specified monitoring period afterwards.
     */
    val rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * The name or unique stack ID of the stack to update.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * Structure containing a new stack policy body. You can specify either the
     * StackPolicyBody or the StackPolicyURL parameter, but not
     * both.
     * You might update the stack policy, for example, in order to protect a new resource that
     * you created during a stack update. If you don't specify a stack policy, the current policy
     * that is associated with the stack is unchanged.
     */
    val stackPolicyBody: kotlin.String? = builder.stackPolicyBody
    /**
     * Structure containing the temporary overriding stack policy body. You can specify either
     * the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
     * parameter, but not both.
     * If you want to update protected resources, specify a temporary overriding stack policy
     * during this update. If you do not specify a stack policy, the current policy that is
     * associated with the stack will be used.
     */
    val stackPolicyDuringUpdateBody: kotlin.String? = builder.stackPolicyDuringUpdateBody
    /**
     * Location of a file containing the temporary overriding stack policy. The URL must point
     * to a policy (max size: 16KB) located in an S3 bucket in the same Region as the stack. You
     * can specify either the StackPolicyDuringUpdateBody or the
     * StackPolicyDuringUpdateURL parameter, but not both.
     * If you want to update protected resources, specify a temporary overriding stack policy
     * during this update. If you do not specify a stack policy, the current policy that is
     * associated with the stack will be used.
     */
    val stackPolicyDuringUpdateUrl: kotlin.String? = builder.stackPolicyDuringUpdateUrl
    /**
     * Location of a file containing the updated stack policy. The URL must point to a policy
     * (max size: 16KB) located in an S3 bucket in the same Region as the stack. You can specify
     * either the StackPolicyBody or the StackPolicyURL parameter, but
     * not both.
     * You might update the stack policy, for example, in order to protect a new resource that
     * you created during a stack update. If you don't specify a stack policy, the current policy
     * that is associated with the stack is unchanged.
     */
    val stackPolicyUrl: kotlin.String? = builder.stackPolicyUrl
    /**
     * Key-value pairs to associate with this stack. CloudFormation also propagates
     * these tags to supported resources in the stack. You can specify a maximum number of 50
     * tags.
     * If you don't specify this parameter, CloudFormation doesn't modify the stack's
     * tags. If you specify an empty value, CloudFormation removes all associated
     * tags.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Structure containing the template body with a minimum length of 1 byte and a maximum
     * length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy
     * in the CloudFormation User Guide.)
     * Conditional: You must specify only one of the following parameters:
     * TemplateBody, TemplateURL, or set the
     * UsePreviousTemplate to true.
     */
    val templateBody: kotlin.String? = builder.templateBody
    /**
     * Location of file containing the template body. The URL must point to a template that's
     * located in an Amazon S3 bucket or a Systems Manager document. For more information,
     * go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy
     * in the CloudFormation User Guide.
     * Conditional: You must specify only one of the following parameters:
     * TemplateBody, TemplateURL, or set the
     * UsePreviousTemplate to true.
     */
    val templateUrl: kotlin.String? = builder.templateUrl
    /**
     * Reuse the existing template that is associated with the stack that you are
     * updating.
     * Conditional: You must specify only one of the following parameters:
     * TemplateBody, TemplateURL, or set the
     * UsePreviousTemplate to true.
     */
    val usePreviousTemplate: kotlin.Boolean? = builder.usePreviousTemplate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStackRequest(")
        append("capabilities=$capabilities,")
        append("clientRequestToken=$clientRequestToken,")
        append("disableRollback=$disableRollback,")
        append("notificationArNs=$notificationArNs,")
        append("parameters=$parameters,")
        append("resourceTypes=$resourceTypes,")
        append("roleArn=$roleArn,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("stackName=$stackName,")
        append("stackPolicyBody=$stackPolicyBody,")
        append("stackPolicyDuringUpdateBody=$stackPolicyDuringUpdateBody,")
        append("stackPolicyDuringUpdateUrl=$stackPolicyDuringUpdateUrl,")
        append("stackPolicyUrl=$stackPolicyUrl,")
        append("tags=$tags,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl,")
        append("usePreviousTemplate=$usePreviousTemplate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (disableRollback?.hashCode() ?: 0)
        result = 31 * result + (notificationArNs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyBody?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyDuringUpdateBody?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyDuringUpdateUrl?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyUrl?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        result = 31 * result + (usePreviousTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStackRequest

        if (capabilities != other.capabilities) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (disableRollback != other.disableRollback) return false
        if (notificationArNs != other.notificationArNs) return false
        if (parameters != other.parameters) return false
        if (resourceTypes != other.resourceTypes) return false
        if (roleArn != other.roleArn) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (stackName != other.stackName) return false
        if (stackPolicyBody != other.stackPolicyBody) return false
        if (stackPolicyDuringUpdateBody != other.stackPolicyDuringUpdateBody) return false
        if (stackPolicyDuringUpdateUrl != other.stackPolicyDuringUpdateUrl) return false
        if (stackPolicyUrl != other.stackPolicyUrl) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false
        if (usePreviousTemplate != other.usePreviousTemplate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * In some cases, you must explicitly acknowledge that your stack template contains certain
         * capabilities in order for CloudFormation to update the stack.
         *
         *
         *
         * CAPABILITY_IAM and CAPABILITY_NAMED_IAM
         *
         * Some stack templates might include resources that can affect permissions in your
         * Amazon Web Services account; for example, by creating new Identity and Access Management
         * (IAM) users. For those stacks, you must explicitly acknowledge this
         * by specifying one of these capabilities.
         * The following IAM resources require you to specify either the
         * CAPABILITY_IAM or CAPABILITY_NAMED_IAM
         * capability.
         *
         *
         * If you have IAM resources, you can specify either
         * capability.
         *
         * If you have IAM resources with custom names, you
         * must specify CAPABILITY_NAMED_IAM.
         *
         * If you don't specify either of these capabilities, CloudFormation returns an
         * InsufficientCapabilities error.
         *
         *
         * If your stack template contains these resources, we recommend that you review all
         * permissions associated with them and edit their permissions if necessary.
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">AWS::IAM::UserToGroupAddition
         *
         *
         *
         * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation Templates.
         *
         *
         * CAPABILITY_AUTO_EXPAND
         *
         * Some template contain macros. Macros perform custom processing on templates; this
         * can include simple actions like find-and-replace operations, all the way to extensive
         * transformations of entire templates. Because of this, users typically create a change
         * set from the processed template, so that they can review the changes resulting from
         * the macros before actually updating the stack. If your stack template contains one or
         * more macros, and you choose to update a stack directly from the processed template,
         * without first reviewing the resulting changes in a change set, you must acknowledge
         * this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless transforms, which are macros hosted by CloudFormation.
         * If you want to update a stack from a stack template that contains macros
         * and nested stacks, you must update the stack directly from
         * the template using this capability.
         *
         * You should only update stacks directly from a stack template that contains
         * macros if you know what processing the macro performs.
         * Each macro relies on an underlying Lambda service function for
         * processing stack templates. Be aware that the Lambda function owner can update the
         * function operation without CloudFormation being notified.
         *
         * For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using
         * CloudFormation Macros to Perform Custom Processing on
         * Templates.
         */
        var capabilities: List<Capability>? = null
        /**
         * A unique identifier for this UpdateStack request. Specify this token if you
         * plan to retry requests so that CloudFormation knows that you're not attempting to
         * update a stack with the same name. You might retry UpdateStack requests to
         * ensure that CloudFormation successfully received them.
         * All events triggered by a given stack operation are assigned the same client request
         * token, which you can use to track operations. For example, if you execute a
         * CreateStack operation with the token token1, then all the
         * StackEvents generated by that operation will have
         * ClientRequestToken set as token1.
         * In the console, stack operations display the client request token on the Events tab.
         * Stack operations that are initiated from the console use the token format
         * Console-StackOperation-ID, which helps you easily identify the
         * stack operation . For example, if you create a stack using the console, each stack event
         * would be assigned the same token in the following format:
         * Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * Preserve the state of previously provisioned resources when an operation fails.
         * Default: False
         */
        var disableRollback: kotlin.Boolean? = null
        /**
         * Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that CloudFormation associates with the stack. Specify an empty list to remove all
         * notification topics.
         */
        var notificationArNs: List<String>? = null
        /**
         * A list of Parameter structures that specify input parameters for the stack.
         * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter data
         * type.
         */
        var parameters: List<Parameter>? = null
        /**
         * The template resource types that you have permissions to work with for this update stack
         * action, such as AWS::EC2::Instance, AWS::EC2::*, or
         * Custom::MyCustomInstance.
         * If the list of resource types doesn't include a resource that you're updating, the stack
         * update fails. By default, CloudFormation grants permissions to all resource types.
         * Identity and Access Management (IAM) uses this parameter for CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with Identity and Access Management.
         */
        var resourceTypes: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role
         * that CloudFormation assumes to update the stack. CloudFormation uses the
         * role's credentials to make calls on your behalf. CloudFormation always uses this
         * role for all future operations on the stack. Provided that users have permission to operate
         * on the stack, CloudFormation uses this role even if the users don't have permission
         * to pass it. Ensure that the role grants least privilege.
         * If you don't specify a value, CloudFormation uses the role that was previously
         * associated with the stack. If no role is available, CloudFormation uses a temporary
         * session that is generated from your user credentials.
         */
        var roleArn: kotlin.String? = null
        /**
         * The rollback triggers for CloudFormation to monitor during stack creation and
         * updating operations, and for the specified monitoring period afterwards.
         */
        var rollbackConfiguration: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration? = null
        /**
         * The name or unique stack ID of the stack to update.
         */
        var stackName: kotlin.String? = null
        /**
         * Structure containing a new stack policy body. You can specify either the
         * StackPolicyBody or the StackPolicyURL parameter, but not
         * both.
         * You might update the stack policy, for example, in order to protect a new resource that
         * you created during a stack update. If you don't specify a stack policy, the current policy
         * that is associated with the stack is unchanged.
         */
        var stackPolicyBody: kotlin.String? = null
        /**
         * Structure containing the temporary overriding stack policy body. You can specify either
         * the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
         * parameter, but not both.
         * If you want to update protected resources, specify a temporary overriding stack policy
         * during this update. If you do not specify a stack policy, the current policy that is
         * associated with the stack will be used.
         */
        var stackPolicyDuringUpdateBody: kotlin.String? = null
        /**
         * Location of a file containing the temporary overriding stack policy. The URL must point
         * to a policy (max size: 16KB) located in an S3 bucket in the same Region as the stack. You
         * can specify either the StackPolicyDuringUpdateBody or the
         * StackPolicyDuringUpdateURL parameter, but not both.
         * If you want to update protected resources, specify a temporary overriding stack policy
         * during this update. If you do not specify a stack policy, the current policy that is
         * associated with the stack will be used.
         */
        var stackPolicyDuringUpdateUrl: kotlin.String? = null
        /**
         * Location of a file containing the updated stack policy. The URL must point to a policy
         * (max size: 16KB) located in an S3 bucket in the same Region as the stack. You can specify
         * either the StackPolicyBody or the StackPolicyURL parameter, but
         * not both.
         * You might update the stack policy, for example, in order to protect a new resource that
         * you created during a stack update. If you don't specify a stack policy, the current policy
         * that is associated with the stack is unchanged.
         */
        var stackPolicyUrl: kotlin.String? = null
        /**
         * Key-value pairs to associate with this stack. CloudFormation also propagates
         * these tags to supported resources in the stack. You can specify a maximum number of 50
         * tags.
         * If you don't specify this parameter, CloudFormation doesn't modify the stack's
         * tags. If you specify an empty value, CloudFormation removes all associated
         * tags.
         */
        var tags: List<Tag>? = null
        /**
         * Structure containing the template body with a minimum length of 1 byte and a maximum
         * length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy
         * in the CloudFormation User Guide.)
         * Conditional: You must specify only one of the following parameters:
         * TemplateBody, TemplateURL, or set the
         * UsePreviousTemplate to true.
         */
        var templateBody: kotlin.String? = null
        /**
         * Location of file containing the template body. The URL must point to a template that's
         * located in an Amazon S3 bucket or a Systems Manager document. For more information,
         * go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy
         * in the CloudFormation User Guide.
         * Conditional: You must specify only one of the following parameters:
         * TemplateBody, TemplateURL, or set the
         * UsePreviousTemplate to true.
         */
        var templateUrl: kotlin.String? = null
        /**
         * Reuse the existing template that is associated with the stack that you are
         * updating.
         * Conditional: You must specify only one of the following parameters:
         * TemplateBody, TemplateURL, or set the
         * UsePreviousTemplate to true.
         */
        var usePreviousTemplate: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest) : this() {
            this.capabilities = x.capabilities
            this.clientRequestToken = x.clientRequestToken
            this.disableRollback = x.disableRollback
            this.notificationArNs = x.notificationArNs
            this.parameters = x.parameters
            this.resourceTypes = x.resourceTypes
            this.roleArn = x.roleArn
            this.rollbackConfiguration = x.rollbackConfiguration
            this.stackName = x.stackName
            this.stackPolicyBody = x.stackPolicyBody
            this.stackPolicyDuringUpdateBody = x.stackPolicyDuringUpdateBody
            this.stackPolicyDuringUpdateUrl = x.stackPolicyDuringUpdateUrl
            this.stackPolicyUrl = x.stackPolicyUrl
            this.tags = x.tags
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
            this.usePreviousTemplate = x.usePreviousTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.UpdateStackRequest = UpdateStackRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration] inside the given [block]
         */
        fun rollbackConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration.invoke(block)
        }
    }
}
