// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information concerning the specification of a CloudFormation extension
 * in a given account and region.
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-register.html#registry-set-configuration">Configuring extensions at the account level in the
 * CloudFormation User Guide.
 */
class TypeConfigurationDetails private constructor(builder: Builder) {
    /**
     * The alias specified for this configuration, if one was specified when the configuration
     * was set.
     */
    val alias: kotlin.String? = builder.alias
    /**
     * The Amazon Resource Name (ARN) for the configuration data, in this account and
     * region.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A JSON string specifying the configuration data for the extension, in this account and
     * region.
     * If a configuration hasn't been set for a specified extension, CloudFormation
     * returns {}.
     */
    val configuration: kotlin.String? = builder.configuration
    /**
     * Whether or not this configuration data is the default configuration for the
     * extension.
     */
    val isDefaultConfiguration: kotlin.Boolean? = builder.isDefaultConfiguration
    /**
     * When the configuration data was last updated for this extension.
     * If a configuration hasn't been set for a specified extension, CloudFormation
     * returns null.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The Amazon Resource Name (ARN) for the extension, in this account and region.
     * For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type in this account and region. For private extensions, this will
     * be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type in this account and region.
     */
    val typeArn: kotlin.String? = builder.typeArn
    /**
     * The name of the extension.
     */
    val typeName: kotlin.String? = builder.typeName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypeConfigurationDetails(")
        append("alias=$alias,")
        append("arn=$arn,")
        append("configuration=$configuration,")
        append("isDefaultConfiguration=$isDefaultConfiguration,")
        append("lastUpdated=$lastUpdated,")
        append("typeArn=$typeArn,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (isDefaultConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (typeArn?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypeConfigurationDetails

        if (alias != other.alias) return false
        if (arn != other.arn) return false
        if (configuration != other.configuration) return false
        if (isDefaultConfiguration != other.isDefaultConfiguration) return false
        if (lastUpdated != other.lastUpdated) return false
        if (typeArn != other.typeArn) return false
        if (typeName != other.typeName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The alias specified for this configuration, if one was specified when the configuration
         * was set.
         */
        var alias: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the configuration data, in this account and
         * region.
         */
        var arn: kotlin.String? = null
        /**
         * A JSON string specifying the configuration data for the extension, in this account and
         * region.
         * If a configuration hasn't been set for a specified extension, CloudFormation
         * returns {}.
         */
        var configuration: kotlin.String? = null
        /**
         * Whether or not this configuration data is the default configuration for the
         * extension.
         */
        var isDefaultConfiguration: kotlin.Boolean? = null
        /**
         * When the configuration data was last updated for this extension.
         * If a configuration hasn't been set for a specified extension, CloudFormation
         * returns null.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the extension, in this account and region.
         * For public extensions, this will be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html">activate the type in this account and region. For private extensions, this will
         * be the ARN assigned when you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">register the type in this account and region.
         */
        var typeArn: kotlin.String? = null
        /**
         * The name of the extension.
         */
        var typeName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails) : this() {
            this.alias = x.alias
            this.arn = x.arn
            this.configuration = x.configuration
            this.isDefaultConfiguration = x.isDefaultConfiguration
            this.lastUpdated = x.lastUpdated
            this.typeArn = x.typeArn
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails = TypeConfigurationDetails(this)
    }
}
