// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



class TestTypeRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the extension.
     * Conditional: You must specify Arn, or TypeName and
     * Type.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The S3 bucket to which CloudFormation delivers the contract test execution
     * logs.
     * CloudFormation delivers the logs by the time contract testing has completed and
     * the extension has been assigned a test type status of PASSED or
     * FAILED.
     * The user calling TestType must be able to access items in the specified S3
     * bucket. Specifically, the user needs the following permissions:
     *
     *
     *
     * GetObject
     *
     *
     *
     * PutObject
     *
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
     * Condition Keys for Amazon S3 in the Amazon Web Services
     * Identity and Access Management User Guide.
     */
    val logDeliveryBucket: kotlin.String? = builder.logDeliveryBucket
    /**
     * The type of the extension to test.
     * Conditional: You must specify Arn, or TypeName and
     * Type.
     */
    val type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = builder.type
    /**
     * The name of the extension to test.
     * Conditional: You must specify Arn, or TypeName and
     * Type.
     */
    val typeName: kotlin.String? = builder.typeName
    /**
     * The version of the extension to test.
     * You can specify the version id with either Arn, or with
     * TypeName and Type.
     * If you don't specify a version, CloudFormation uses the default version of the
     * extension in this account and region for testing.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestTypeRequest(")
        append("arn=$arn,")
        append("logDeliveryBucket=$logDeliveryBucket,")
        append("type=$type,")
        append("typeName=$typeName,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (logDeliveryBucket?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestTypeRequest

        if (arn != other.arn) return false
        if (logDeliveryBucket != other.logDeliveryBucket) return false
        if (type != other.type) return false
        if (typeName != other.typeName) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the extension.
         * Conditional: You must specify Arn, or TypeName and
         * Type.
         */
        var arn: kotlin.String? = null
        /**
         * The S3 bucket to which CloudFormation delivers the contract test execution
         * logs.
         * CloudFormation delivers the logs by the time contract testing has completed and
         * the extension has been assigned a test type status of PASSED or
         * FAILED.
         * The user calling TestType must be able to access items in the specified S3
         * bucket. Specifically, the user needs the following permissions:
         *
         *
         *
         * GetObject
         *
         *
         *
         * PutObject
         *
         *
         *
         * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and
         * Condition Keys for Amazon S3 in the Amazon Web Services
         * Identity and Access Management User Guide.
         */
        var logDeliveryBucket: kotlin.String? = null
        /**
         * The type of the extension to test.
         * Conditional: You must specify Arn, or TypeName and
         * Type.
         */
        var type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = null
        /**
         * The name of the extension to test.
         * Conditional: You must specify Arn, or TypeName and
         * Type.
         */
        var typeName: kotlin.String? = null
        /**
         * The version of the extension to test.
         * You can specify the version id with either Arn, or with
         * TypeName and Type.
         * If you don't specify a version, CloudFormation uses the default version of the
         * extension in this account and region for testing.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest) : this() {
            this.arn = x.arn
            this.logDeliveryBucket = x.logDeliveryBucket
            this.type = x.type
            this.typeName = x.typeName
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TestTypeRequest = TestTypeRequest(this)
    }
}
