// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structures that contain summary information about the specified stack set.
 */
class StackSetSummary private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to
     * Organizations accounts that are added to a target organizational unit
     * (OU).
     */
    val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * A description of the stack set that you specify when the stack set is created or
     * updated.
     */
    val description: kotlin.String? = builder.description
    /**
     * Status of the stack set's actual configuration compared to its expected template and
     * parameter configuration. A stack set is considered to have drifted if one or more of its
     * stack instances have drifted from their expected template and parameter
     * configuration.
     *
     *
     *
     * DRIFTED: One or more of the stack instances belonging to the stack
     * set stack differs from the expected template and parameter configuration. A stack
     * instance is considered to have drifted if one or more of the resources in the
     * associated stack have drifted.
     *
     *
     * NOT_CHECKED: CloudFormation hasn't checked the stack set for drift.
     *
     *
     * IN_SYNC: All the stack instances belonging to the stack set stack
     * match from the expected template and parameter configuration.
     *
     *
     * UNKNOWN: This value is reserved for future use.
     */
    val driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = builder.driftStatus
    /**
     * Most recent time when CloudFormation performed a drift detection operation on
     * the stack set. This value will be NULL for any stack set on which drift
     * detection hasn't yet been performed.
     */
    val lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDriftCheckTimestamp
    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues
     * conflicting operations.
     */
    val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * Describes how the IAM roles required for stack set operations are
     * created.
     *
     *
     * With self-managed permissions, you must create the administrator and
     * execution roles required to deploy to target accounts. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions.
     *
     * With service-managed permissions, StackSets automatically creates the
     * IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions.
     */
    val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * The ID of the stack set.
     */
    val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The name of the stack set.
     */
    val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The status of the stack set.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetSummary(")
        append("autoDeployment=$autoDeployment,")
        append("description=$description,")
        append("driftStatus=$driftStatus,")
        append("lastDriftCheckTimestamp=$lastDriftCheckTimestamp,")
        append("managedExecution=$managedExecution,")
        append("permissionModel=$permissionModel,")
        append("stackSetId=$stackSetId,")
        append("stackSetName=$stackSetName,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoDeployment?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (lastDriftCheckTimestamp?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetSummary

        if (autoDeployment != other.autoDeployment) return false
        if (description != other.description) return false
        if (driftStatus != other.driftStatus) return false
        if (lastDriftCheckTimestamp != other.lastDriftCheckTimestamp) return false
        if (managedExecution != other.managedExecution) return false
        if (permissionModel != other.permissionModel) return false
        if (stackSetId != other.stackSetId) return false
        if (stackSetName != other.stackSetName) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to
         * Organizations accounts that are added to a target organizational unit
         * (OU).
         */
        var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * A description of the stack set that you specify when the stack set is created or
         * updated.
         */
        var description: kotlin.String? = null
        /**
         * Status of the stack set's actual configuration compared to its expected template and
         * parameter configuration. A stack set is considered to have drifted if one or more of its
         * stack instances have drifted from their expected template and parameter
         * configuration.
         *
         *
         *
         * DRIFTED: One or more of the stack instances belonging to the stack
         * set stack differs from the expected template and parameter configuration. A stack
         * instance is considered to have drifted if one or more of the resources in the
         * associated stack have drifted.
         *
         *
         * NOT_CHECKED: CloudFormation hasn't checked the stack set for drift.
         *
         *
         * IN_SYNC: All the stack instances belonging to the stack set stack
         * match from the expected template and parameter configuration.
         *
         *
         * UNKNOWN: This value is reserved for future use.
         */
        var driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = null
        /**
         * Most recent time when CloudFormation performed a drift detection operation on
         * the stack set. This value will be NULL for any stack set on which drift
         * detection hasn't yet been performed.
         */
        var lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues
         * conflicting operations.
         */
        var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * Describes how the IAM roles required for stack set operations are
         * created.
         *
         *
         * With self-managed permissions, you must create the administrator and
         * execution roles required to deploy to target accounts. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
         * Self-Managed Stack Set Permissions.
         *
         * With service-managed permissions, StackSets automatically creates the
         * IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions.
         */
        var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * The ID of the stack set.
         */
        var stackSetId: kotlin.String? = null
        /**
         * The name of the stack set.
         */
        var stackSetName: kotlin.String? = null
        /**
         * The status of the stack set.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetSummary) : this() {
            this.autoDeployment = x.autoDeployment
            this.description = x.description
            this.driftStatus = x.driftStatus
            this.lastDriftCheckTimestamp = x.lastDriftCheckTimestamp
            this.managedExecution = x.managedExecution
            this.permissionModel = x.permissionModel
            this.stackSetId = x.stackSetId
            this.stackSetName = x.stackSetName
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetSummary = StackSetSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }
    }
}
