// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structures that contain summary information about the specified operation.
 */
class StackSetOperationSummary private constructor(builder: Builder) {
    /**
     * The type of operation: CREATE, UPDATE, or DELETE.
     * Create and delete operations affect only the specified stack instances that are associated
     * with the specified stack set. Update operations affect both the stack set itself and
     * all associated stack set instances.
     */
    val action: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction? = builder.action
    /**
     * The time at which the operation was initiated. Note that the creation times for the
     * stack set operation might differ from the creation time of the individual stacks
     * themselves. This is because CloudFormation needs to perform preparatory work for
     * the operation, such as dispatching the work to the requested Regions, before actually
     * creating the first stacks.
     */
    val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The time at which the stack set operation ended, across all accounts and Regions
     * specified. Note that this doesn't necessarily mean that the stack set operation was
     * successful, or even attempted, in each account or Region.
     */
    val endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.endTimestamp
    /**
     * The unique ID of the stack set operation.
     */
    val operationId: kotlin.String? = builder.operationId
    /**
     * The overall status of the operation.
     *
     *
     *
     * FAILED: The operation exceeded the specified failure tolerance. The
     * failure tolerance value that you've set for an operation is applied for each Region
     * during stack create and update operations. If the number of failed stacks within a
     * Region exceeds the failure tolerance, the status of the operation in the Region is
     * set to FAILED. This in turn sets the status of the operation as a whole
     * to FAILED, and CloudFormation cancels the operation in any
     * remaining Regions.
     *
     *
     * QUEUED: &#91;Service-managed permissions&#93; For automatic deployments that
     * require a sequence of operations, the operation is queued to be performed. For more
     * information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes in the CloudFormation User Guide.
     *
     *
     * RUNNING: The operation is currently being performed.
     *
     *
     * STOPPED: The user has canceled the operation.
     *
     *
     * STOPPING: The operation is in the process of stopping, at user
     * request.
     *
     *
     * SUCCEEDED: The operation completed creating or updating all the
     * specified stacks without exceeding the failure tolerance for the operation.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetOperationSummary(")
        append("action=$action,")
        append("creationTimestamp=$creationTimestamp,")
        append("endTimestamp=$endTimestamp,")
        append("operationId=$operationId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endTimestamp?.hashCode() ?: 0)
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetOperationSummary

        if (action != other.action) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (endTimestamp != other.endTimestamp) return false
        if (operationId != other.operationId) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of operation: CREATE, UPDATE, or DELETE.
         * Create and delete operations affect only the specified stack instances that are associated
         * with the specified stack set. Update operations affect both the stack set itself and
         * all associated stack set instances.
         */
        var action: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction? = null
        /**
         * The time at which the operation was initiated. Note that the creation times for the
         * stack set operation might differ from the creation time of the individual stacks
         * themselves. This is because CloudFormation needs to perform preparatory work for
         * the operation, such as dispatching the work to the requested Regions, before actually
         * creating the first stacks.
         */
        var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the stack set operation ended, across all accounts and Regions
         * specified. Note that this doesn't necessarily mean that the stack set operation was
         * successful, or even attempted, in each account or Region.
         */
        var endTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the stack set operation.
         */
        var operationId: kotlin.String? = null
        /**
         * The overall status of the operation.
         *
         *
         *
         * FAILED: The operation exceeded the specified failure tolerance. The
         * failure tolerance value that you've set for an operation is applied for each Region
         * during stack create and update operations. If the number of failed stacks within a
         * Region exceeds the failure tolerance, the status of the operation in the Region is
         * set to FAILED. This in turn sets the status of the operation as a whole
         * to FAILED, and CloudFormation cancels the operation in any
         * remaining Regions.
         *
         *
         * QUEUED: &#91;Service-managed permissions&#93; For automatic deployments that
         * require a sequence of operations, the operation is queued to be performed. For more
         * information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes in the CloudFormation User Guide.
         *
         *
         * RUNNING: The operation is currently being performed.
         *
         *
         * STOPPED: The user has canceled the operation.
         *
         *
         * STOPPING: The operation is in the process of stopping, at user
         * request.
         *
         *
         * SUCCEEDED: The operation completed creating or updating all the
         * specified stacks without exceeding the failure tolerance for the operation.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary) : this() {
            this.action = x.action
            this.creationTimestamp = x.creationTimestamp
            this.endTimestamp = x.endTimestamp
            this.operationId = x.operationId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary = StackSetOperationSummary(this)
    }
}
