// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * A structure that contains information about a stack set. A stack set enables you to
 * provision stacks into Amazon Web Services accounts and across Regions by using a single
 * CloudFormation template. In the stack set, you specify the template to use, in
 * addition to any parameters and capabilities that the template requires.
 */
class StackSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of the IAM role used to create or update
     * the stack set.
     * Use customized administrator roles to control which users or groups can manage specific
     * stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack
     * Set Operations in the CloudFormation User Guide.
     */
    val administrationRoleArn: kotlin.String? = builder.administrationRoleArn
    /**
     * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to
     * Organizations accounts that are added to a target organization or organizational
     * unit (OU).
     */
    val autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = builder.autoDeployment
    /**
     * The capabilities that are allowed in the stack set. Some stack set templates might
     * include resources that can affect permissions in your Amazon Web Services account—for
     * example, by creating new Identity and Access Management (IAM) users. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation
     * Templates.
     */
    val capabilities: List<Capability>? = builder.capabilities
    /**
     * A description of the stack set that you specify when the stack set is created or
     * updated.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the IAM execution role used to create or update the stack
     * set.
     * Use customized execution roles to control which stack resources users and groups can
     * include in their stack sets.
     */
    val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * Describes whether StackSets performs non-conflicting operations concurrently and queues
     * conflicting operations.
     */
    val managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = builder.managedExecution
    /**
     * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs
     * that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets.
     */
    val organizationalUnitIds: List<String>? = builder.organizationalUnitIds
    /**
     * A list of input parameters for a stack set.
     */
    val parameters: List<Parameter>? = builder.parameters
    /**
     * Describes how the IAM roles required for stack set operations are
     * created.
     *
     *
     * With self-managed permissions, you must create the administrator and
     * execution roles required to deploy to target accounts. For more information, see
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions.
     *
     * With service-managed permissions, StackSets automatically creates the
     * IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions.
     */
    val permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = builder.permissionModel
    /**
     * The Amazon Resource Number (ARN) of the stack set.
     */
    val stackSetArn: kotlin.String? = builder.stackSetArn
    /**
     * Detailed information about the drift status of the stack set.
     * For stack sets, contains information about the last completed drift
     * operation performed on the stack set. Information about drift operations currently in
     * progress isn't included.
     */
    val stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = builder.stackSetDriftDetectionDetails
    /**
     * The ID of the stack set.
     */
    val stackSetId: kotlin.String? = builder.stackSetId
    /**
     * The name that's associated with the stack set.
     */
    val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The status of the stack set.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = builder.status
    /**
     * A list of tags that specify information about the stack set. A maximum number of 50 tags
     * can be specified.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The structure that contains the body of the template that was used to create or update
     * the stack set.
     */
    val templateBody: kotlin.String? = builder.templateBody

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSet(")
        append("administrationRoleArn=$administrationRoleArn,")
        append("autoDeployment=$autoDeployment,")
        append("capabilities=$capabilities,")
        append("description=$description,")
        append("executionRoleName=$executionRoleName,")
        append("managedExecution=$managedExecution,")
        append("organizationalUnitIds=$organizationalUnitIds,")
        append("parameters=$parameters,")
        append("permissionModel=$permissionModel,")
        append("stackSetArn=$stackSetArn,")
        append("stackSetDriftDetectionDetails=$stackSetDriftDetectionDetails,")
        append("stackSetId=$stackSetId,")
        append("stackSetName=$stackSetName,")
        append("status=$status,")
        append("tags=$tags,")
        append("templateBody=$templateBody)")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrationRoleArn?.hashCode() ?: 0
        result = 31 * result + (autoDeployment?.hashCode() ?: 0)
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (managedExecution?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (stackSetArn?.hashCode() ?: 0)
        result = 31 * result + (stackSetDriftDetectionDetails?.hashCode() ?: 0)
        result = 31 * result + (stackSetId?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSet

        if (administrationRoleArn != other.administrationRoleArn) return false
        if (autoDeployment != other.autoDeployment) return false
        if (capabilities != other.capabilities) return false
        if (description != other.description) return false
        if (executionRoleName != other.executionRoleName) return false
        if (managedExecution != other.managedExecution) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false
        if (parameters != other.parameters) return false
        if (permissionModel != other.permissionModel) return false
        if (stackSetArn != other.stackSetArn) return false
        if (stackSetDriftDetectionDetails != other.stackSetDriftDetectionDetails) return false
        if (stackSetId != other.stackSetId) return false
        if (stackSetName != other.stackSetName) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (templateBody != other.templateBody) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Number (ARN) of the IAM role used to create or update
         * the stack set.
         * Use customized administrator roles to control which users or groups can manage specific
         * stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack
         * Set Operations in the CloudFormation User Guide.
         */
        var administrationRoleArn: kotlin.String? = null
        /**
         * &#91;Service-managed permissions&#93; Describes whether StackSets automatically deploys to
         * Organizations accounts that are added to a target organization or organizational
         * unit (OU).
         */
        var autoDeployment: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment? = null
        /**
         * The capabilities that are allowed in the stack set. Some stack set templates might
         * include resources that can affect permissions in your Amazon Web Services account—for
         * example, by creating new Identity and Access Management (IAM) users. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in CloudFormation
         * Templates.
         */
        var capabilities: List<Capability>? = null
        /**
         * A description of the stack set that you specify when the stack set is created or
         * updated.
         */
        var description: kotlin.String? = null
        /**
         * The name of the IAM execution role used to create or update the stack
         * set.
         * Use customized execution roles to control which stack resources users and groups can
         * include in their stack sets.
         */
        var executionRoleName: kotlin.String? = null
        /**
         * Describes whether StackSets performs non-conflicting operations concurrently and queues
         * conflicting operations.
         */
        var managedExecution: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution? = null
        /**
         * &#91;Service-managed permissions&#93; The organization root ID or organizational unit (OU) IDs
         * that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets.
         */
        var organizationalUnitIds: List<String>? = null
        /**
         * A list of input parameters for a stack set.
         */
        var parameters: List<Parameter>? = null
        /**
         * Describes how the IAM roles required for stack set operations are
         * created.
         *
         *
         * With self-managed permissions, you must create the administrator and
         * execution roles required to deploy to target accounts. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
         * Self-Managed Stack Set Permissions.
         *
         * With service-managed permissions, StackSets automatically creates the
         * IAM roles required to deploy to accounts managed by Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions.
         */
        var permissionModel: aws.sdk.kotlin.services.cloudformation.model.PermissionModels? = null
        /**
         * The Amazon Resource Number (ARN) of the stack set.
         */
        var stackSetArn: kotlin.String? = null
        /**
         * Detailed information about the drift status of the stack set.
         * For stack sets, contains information about the last completed drift
         * operation performed on the stack set. Information about drift operations currently in
         * progress isn't included.
         */
        var stackSetDriftDetectionDetails: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails? = null
        /**
         * The ID of the stack set.
         */
        var stackSetId: kotlin.String? = null
        /**
         * The name that's associated with the stack set.
         */
        var stackSetName: kotlin.String? = null
        /**
         * The status of the stack set.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = null
        /**
         * A list of tags that specify information about the stack set. A maximum number of 50 tags
         * can be specified.
         */
        var tags: List<Tag>? = null
        /**
         * The structure that contains the body of the template that was used to create or update
         * the stack set.
         */
        var templateBody: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSet) : this() {
            this.administrationRoleArn = x.administrationRoleArn
            this.autoDeployment = x.autoDeployment
            this.capabilities = x.capabilities
            this.description = x.description
            this.executionRoleName = x.executionRoleName
            this.managedExecution = x.managedExecution
            this.organizationalUnitIds = x.organizationalUnitIds
            this.parameters = x.parameters
            this.permissionModel = x.permissionModel
            this.stackSetArn = x.stackSetArn
            this.stackSetDriftDetectionDetails = x.stackSetDriftDetectionDetails
            this.stackSetId = x.stackSetId
            this.stackSetName = x.stackSetName
            this.status = x.status
            this.tags = x.tags
            this.templateBody = x.templateBody
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSet = StackSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.AutoDeployment] inside the given [block]
         */
        fun autoDeployment(block: aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.Builder.() -> kotlin.Unit) {
            this.autoDeployment = aws.sdk.kotlin.services.cloudformation.model.AutoDeployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ManagedExecution] inside the given [block]
         */
        fun managedExecution(block: aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.Builder.() -> kotlin.Unit) {
            this.managedExecution = aws.sdk.kotlin.services.cloudformation.model.ManagedExecution.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails] inside the given [block]
         */
        fun stackSetDriftDetectionDetails(block: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.Builder.() -> kotlin.Unit) {
            this.stackSetDriftDetectionDetails = aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails.invoke(block)
        }
    }
}
