// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summarizes information about whether the resource's actual configuration differs, or has
 * drifted, from its expected configuration.
 */
class StackResourceDriftInformationSummary private constructor(builder: Builder) {
    /**
     * When CloudFormation last checked if the resource had drifted from its expected
     * configuration.
     */
    val lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastCheckTimestamp
    /**
     * Status of the resource's actual configuration compared to its expected
     * configuration.
     *
     *
     *
     * DELETED: The resource differs from its expected configuration in that
     * it has been deleted.
     *
     *
     * MODIFIED: The resource differs from its expected
     * configuration.
     *
     *
     * NOT_CHECKED: CloudFormation hasn't checked if the resource differs from its
     * expected configuration.
     * Any resources that don't currently support drift detection have a status of
     * NOT_CHECKED. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection. If you performed an ContinueUpdateRollback operation on a stack, any resources included in
     * ResourcesToSkip will also have a status of NOT_CHECKED.
     * For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update in the CloudFormation User Guide.
     *
     *
     * IN_SYNC: The resource's actual configuration matches its expected
     * configuration.
     */
    val stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = builder.stackResourceDriftStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackResourceDriftInformationSummary(")
        append("lastCheckTimestamp=$lastCheckTimestamp,")
        append("stackResourceDriftStatus=$stackResourceDriftStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastCheckTimestamp?.hashCode() ?: 0
        result = 31 * result + (stackResourceDriftStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackResourceDriftInformationSummary

        if (lastCheckTimestamp != other.lastCheckTimestamp) return false
        if (stackResourceDriftStatus != other.stackResourceDriftStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * When CloudFormation last checked if the resource had drifted from its expected
         * configuration.
         */
        var lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the resource's actual configuration compared to its expected
         * configuration.
         *
         *
         *
         * DELETED: The resource differs from its expected configuration in that
         * it has been deleted.
         *
         *
         * MODIFIED: The resource differs from its expected
         * configuration.
         *
         *
         * NOT_CHECKED: CloudFormation hasn't checked if the resource differs from its
         * expected configuration.
         * Any resources that don't currently support drift detection have a status of
         * NOT_CHECKED. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection. If you performed an ContinueUpdateRollback operation on a stack, any resources included in
         * ResourcesToSkip will also have a status of NOT_CHECKED.
         * For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update in the CloudFormation User Guide.
         *
         *
         * IN_SYNC: The resource's actual configuration matches its expected
         * configuration.
         */
        var stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformationSummary) : this() {
            this.lastCheckTimestamp = x.lastCheckTimestamp
            this.stackResourceDriftStatus = x.stackResourceDriftStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformationSummary = StackResourceDriftInformationSummary(this)
    }
}
