// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The StackResource data type.
 */
class StackResource private constructor(builder: Builder) {
    /**
     * User defined description associated with the resource.
     */
    val description: kotlin.String? = builder.description
    /**
     * Information about whether the resource's actual configuration differs, or has
     * drifted, from its expected configuration, as defined in the stack
     * template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration
     * Changes to Stacks and Resources.
     */
    val driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation? = builder.driftInformation
    /**
     * The logical name of the resource specified in the template.
     */
    val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * Contains information about the module from which the resource was created, if the
     * resource was created from a module included in the stack template.
     */
    val moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = builder.moduleInfo
    /**
     * The name or unique identifier that corresponds to a physical instance ID of a resource
     * supported by CloudFormation.
     */
    val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * Current status of the resource.
     */
    val resourceStatus: aws.sdk.kotlin.services.cloudformation.model.ResourceStatus? = builder.resourceStatus
    /**
     * Success/failure message associated with the resource.
     */
    val resourceStatusReason: kotlin.String? = builder.resourceStatusReason
    /**
     * Type of resource. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference in the CloudFormation User
     * Guide.
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * Unique identifier of the stack.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The name associated with the stack.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * Time the status was updated.
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackResource(")
        append("description=$description,")
        append("driftInformation=$driftInformation,")
        append("logicalResourceId=$logicalResourceId,")
        append("moduleInfo=$moduleInfo,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceStatus=$resourceStatus,")
        append("resourceStatusReason=$resourceStatusReason,")
        append("resourceType=$resourceType,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (driftInformation?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (moduleInfo?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceStatusReason?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackResource

        if (description != other.description) return false
        if (driftInformation != other.driftInformation) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (moduleInfo != other.moduleInfo) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceStatus != other.resourceStatus) return false
        if (resourceStatusReason != other.resourceStatusReason) return false
        if (resourceType != other.resourceType) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackResource = Builder(this).apply(block).build()

    class Builder {
        /**
         * User defined description associated with the resource.
         */
        var description: kotlin.String? = null
        /**
         * Information about whether the resource's actual configuration differs, or has
         * drifted, from its expected configuration, as defined in the stack
         * template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration
         * Changes to Stacks and Resources.
         */
        var driftInformation: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation? = null
        /**
         * The logical name of the resource specified in the template.
         */
        var logicalResourceId: kotlin.String? = null
        /**
         * Contains information about the module from which the resource was created, if the
         * resource was created from a module included in the stack template.
         */
        var moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = null
        /**
         * The name or unique identifier that corresponds to a physical instance ID of a resource
         * supported by CloudFormation.
         */
        var physicalResourceId: kotlin.String? = null
        /**
         * Current status of the resource.
         */
        var resourceStatus: aws.sdk.kotlin.services.cloudformation.model.ResourceStatus? = null
        /**
         * Success/failure message associated with the resource.
         */
        var resourceStatusReason: kotlin.String? = null
        /**
         * Type of resource. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference in the CloudFormation User
         * Guide.
         */
        var resourceType: kotlin.String? = null
        /**
         * Unique identifier of the stack.
         */
        var stackId: kotlin.String? = null
        /**
         * The name associated with the stack.
         */
        var stackName: kotlin.String? = null
        /**
         * Time the status was updated.
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackResource) : this() {
            this.description = x.description
            this.driftInformation = x.driftInformation
            this.logicalResourceId = x.logicalResourceId
            this.moduleInfo = x.moduleInfo
            this.physicalResourceId = x.physicalResourceId
            this.resourceStatus = x.resourceStatus
            this.resourceStatusReason = x.resourceStatusReason
            this.resourceType = x.resourceType
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackResource = StackResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation] inside the given [block]
         */
        fun driftInformation(block: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation.Builder.() -> kotlin.Unit) {
            this.driftInformation = aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ModuleInfo] inside the given [block]
         */
        fun moduleInfo(block: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.Builder.() -> kotlin.Unit) {
            this.moduleInfo = aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.invoke(block)
        }
    }
}
