// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The StackEvent data type.
 */
class StackEvent private constructor(builder: Builder) {
    /**
     * The token passed to the operation that generated this event.
     * All events triggered by a given stack operation are assigned the same client request
     * token, which you can use to track operations. For example, if you execute a
     * CreateStack operation with the token token1, then all the
     * StackEvents generated by that operation will have
     * ClientRequestToken set as token1.
     * In the console, stack operations display the client request token on the Events tab.
     * Stack operations that are initiated from the console use the token format
     * Console-StackOperation-ID, which helps you easily identify the
     * stack operation . For example, if you create a stack using the console, each stack event
     * would be assigned the same token in the following format:
     * Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The unique ID of this event.
     */
    val eventId: kotlin.String? = builder.eventId
    /**
     * Specify the hook failure mode for non-compliant resources in the followings ways.
     *
     *
     *
     * FAIL Stops provisioning resources.
     *
     *
     * WARN Allows provisioning to continue with a warning message.
     */
    val hookFailureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = builder.hookFailureMode
    /**
     * Invocation points are points in provisioning logic where hooks are initiated.
     */
    val hookInvocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = builder.hookInvocationPoint
    /**
     * Provides the status of the change set hook.
     */
    val hookStatus: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = builder.hookStatus
    /**
     * Provides the reason for the hook status.
     */
    val hookStatusReason: kotlin.String? = builder.hookStatusReason
    /**
     * The name of the hook.
     */
    val hookType: kotlin.String? = builder.hookType
    /**
     * The logical name of the resource specified in the template.
     */
    val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * The name or unique identifier associated with the physical instance of the
     * resource.
     */
    val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * BLOB of the properties used to create the resource.
     */
    val resourceProperties: kotlin.String? = builder.resourceProperties
    /**
     * Current status of the resource.
     */
    val resourceStatus: aws.sdk.kotlin.services.cloudformation.model.ResourceStatus? = builder.resourceStatus
    /**
     * Success/failure message associated with the resource.
     */
    val resourceStatusReason: kotlin.String? = builder.resourceStatusReason
    /**
     * Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference in the CloudFormation User Guide.)
     */
    val resourceType: kotlin.String? = builder.resourceType
    /**
     * The unique ID name of the instance of the stack.
     */
    val stackId: kotlin.String? = builder.stackId
    /**
     * The name associated with a stack.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * Time the status was updated.
     */
    val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackEvent(")
        append("clientRequestToken=$clientRequestToken,")
        append("eventId=$eventId,")
        append("hookFailureMode=$hookFailureMode,")
        append("hookInvocationPoint=$hookInvocationPoint,")
        append("hookStatus=$hookStatus,")
        append("hookStatusReason=$hookStatusReason,")
        append("hookType=$hookType,")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceProperties=$resourceProperties,")
        append("resourceStatus=$resourceStatus,")
        append("resourceStatusReason=$resourceStatusReason,")
        append("resourceType=$resourceType,")
        append("stackId=$stackId,")
        append("stackName=$stackName,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (hookFailureMode?.hashCode() ?: 0)
        result = 31 * result + (hookInvocationPoint?.hashCode() ?: 0)
        result = 31 * result + (hookStatus?.hashCode() ?: 0)
        result = 31 * result + (hookStatusReason?.hashCode() ?: 0)
        result = 31 * result + (hookType?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceProperties?.hashCode() ?: 0)
        result = 31 * result + (resourceStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceStatusReason?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackEvent

        if (clientRequestToken != other.clientRequestToken) return false
        if (eventId != other.eventId) return false
        if (hookFailureMode != other.hookFailureMode) return false
        if (hookInvocationPoint != other.hookInvocationPoint) return false
        if (hookStatus != other.hookStatus) return false
        if (hookStatusReason != other.hookStatusReason) return false
        if (hookType != other.hookType) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceProperties != other.resourceProperties) return false
        if (resourceStatus != other.resourceStatus) return false
        if (resourceStatusReason != other.resourceStatusReason) return false
        if (resourceType != other.resourceType) return false
        if (stackId != other.stackId) return false
        if (stackName != other.stackName) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackEvent = Builder(this).apply(block).build()

    class Builder {
        /**
         * The token passed to the operation that generated this event.
         * All events triggered by a given stack operation are assigned the same client request
         * token, which you can use to track operations. For example, if you execute a
         * CreateStack operation with the token token1, then all the
         * StackEvents generated by that operation will have
         * ClientRequestToken set as token1.
         * In the console, stack operations display the client request token on the Events tab.
         * Stack operations that are initiated from the console use the token format
         * Console-StackOperation-ID, which helps you easily identify the
         * stack operation . For example, if you create a stack using the console, each stack event
         * would be assigned the same token in the following format:
         * Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The unique ID of this event.
         */
        var eventId: kotlin.String? = null
        /**
         * Specify the hook failure mode for non-compliant resources in the followings ways.
         *
         *
         *
         * FAIL Stops provisioning resources.
         *
         *
         * WARN Allows provisioning to continue with a warning message.
         */
        var hookFailureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = null
        /**
         * Invocation points are points in provisioning logic where hooks are initiated.
         */
        var hookInvocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = null
        /**
         * Provides the status of the change set hook.
         */
        var hookStatus: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = null
        /**
         * Provides the reason for the hook status.
         */
        var hookStatusReason: kotlin.String? = null
        /**
         * The name of the hook.
         */
        var hookType: kotlin.String? = null
        /**
         * The logical name of the resource specified in the template.
         */
        var logicalResourceId: kotlin.String? = null
        /**
         * The name or unique identifier associated with the physical instance of the
         * resource.
         */
        var physicalResourceId: kotlin.String? = null
        /**
         * BLOB of the properties used to create the resource.
         */
        var resourceProperties: kotlin.String? = null
        /**
         * Current status of the resource.
         */
        var resourceStatus: aws.sdk.kotlin.services.cloudformation.model.ResourceStatus? = null
        /**
         * Success/failure message associated with the resource.
         */
        var resourceStatusReason: kotlin.String? = null
        /**
         * Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services Resource Types Reference in the CloudFormation User Guide.)
         */
        var resourceType: kotlin.String? = null
        /**
         * The unique ID name of the instance of the stack.
         */
        var stackId: kotlin.String? = null
        /**
         * The name associated with a stack.
         */
        var stackName: kotlin.String? = null
        /**
         * Time the status was updated.
         */
        var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackEvent) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.eventId = x.eventId
            this.hookFailureMode = x.hookFailureMode
            this.hookInvocationPoint = x.hookInvocationPoint
            this.hookStatus = x.hookStatus
            this.hookStatusReason = x.hookStatusReason
            this.hookType = x.hookType
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceProperties = x.resourceProperties
            this.resourceStatus = x.resourceStatus
            this.resourceStatusReason = x.resourceStatusReason
            this.resourceType = x.resourceType
            this.stackId = x.stackId
            this.stackName = x.stackName
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackEvent = StackEvent(this)
    }
}
