// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about whether the stack's actual configuration differs, or has
 * drifted, from its expected configuration, as defined in the stack
 * template and any values specified as template parameters. A stack is considered to have
 * drifted if one or more of its resources have drifted.
 */
class StackDriftInformation private constructor(builder: Builder) {
    /**
     * Most recent time when a drift detection operation was initiated on the stack, or any of
     * its individual resources that support drift detection.
     */
    val lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastCheckTimestamp
    /**
     * Status of the stack's actual configuration compared to its expected template
     * configuration.
     *
     *
     *
     * DRIFTED: The stack differs from its expected template configuration.
     * A stack is considered to have drifted if one or more of its resources have
     * drifted.
     *
     *
     * NOT_CHECKED: CloudFormation hasn't checked if the stack differs from its
     * expected template configuration.
     *
     *
     * IN_SYNC: The stack's actual configuration matches its expected
     * template configuration.
     *
     *
     * UNKNOWN: This value is reserved for future use.
     */
    val stackDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = builder.stackDriftStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackDriftInformation(")
        append("lastCheckTimestamp=$lastCheckTimestamp,")
        append("stackDriftStatus=$stackDriftStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastCheckTimestamp?.hashCode() ?: 0
        result = 31 * result + (stackDriftStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackDriftInformation

        if (lastCheckTimestamp != other.lastCheckTimestamp) return false
        if (stackDriftStatus != other.stackDriftStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation = Builder(this).apply(block).build()

    class Builder {
        /**
         * Most recent time when a drift detection operation was initiated on the stack, or any of
         * its individual resources that support drift detection.
         */
        var lastCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the stack's actual configuration compared to its expected template
         * configuration.
         *
         *
         *
         * DRIFTED: The stack differs from its expected template configuration.
         * A stack is considered to have drifted if one or more of its resources have
         * drifted.
         *
         *
         * NOT_CHECKED: CloudFormation hasn't checked if the stack differs from its
         * expected template configuration.
         *
         *
         * IN_SYNC: The stack's actual configuration matches its expected
         * template configuration.
         *
         *
         * UNKNOWN: This value is reserved for future use.
         */
        var stackDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation) : this() {
            this.lastCheckTimestamp = x.lastCheckTimestamp
            this.stackDriftStatus = x.stackDriftStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackDriftInformation = StackDriftInformation(this)
    }
}
