// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for the SignalResource action.
 */
class SignalResourceRequest private constructor(builder: Builder) {
    /**
     * The logical ID of the resource that you want to signal. The logical ID is the name of
     * the resource that given in the template.
     */
    val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * The stack name or unique stack ID that includes the resource that you want to
     * signal.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * The status of the signal, which is either success or failure. A failure signal causes
     * CloudFormation to immediately fail the stack creation or update.
     */
    val status: aws.sdk.kotlin.services.cloudformation.model.ResourceSignalStatus? = builder.status
    /**
     * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID that you are signaling as the unique ID. If
     * you send multiple signals to a single resource (such as signaling a wait condition), each
     * signal requires a different unique ID.
     */
    val uniqueId: kotlin.String? = builder.uniqueId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignalResourceRequest(")
        append("logicalResourceId=$logicalResourceId,")
        append("stackName=$stackName,")
        append("status=$status,")
        append("uniqueId=$uniqueId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (uniqueId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignalResourceRequest

        if (logicalResourceId != other.logicalResourceId) return false
        if (stackName != other.stackName) return false
        if (status != other.status) return false
        if (uniqueId != other.uniqueId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The logical ID of the resource that you want to signal. The logical ID is the name of
         * the resource that given in the template.
         */
        var logicalResourceId: kotlin.String? = null
        /**
         * The stack name or unique stack ID that includes the resource that you want to
         * signal.
         */
        var stackName: kotlin.String? = null
        /**
         * The status of the signal, which is either success or failure. A failure signal causes
         * CloudFormation to immediately fail the stack creation or update.
         */
        var status: aws.sdk.kotlin.services.cloudformation.model.ResourceSignalStatus? = null
        /**
         * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID that you are signaling as the unique ID. If
         * you send multiple signals to a single resource (such as signaling a wait condition), each
         * signal requires a different unique ID.
         */
        var uniqueId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.stackName = x.stackName
            this.status = x.status
            this.uniqueId = x.uniqueId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.SignalResourceRequest = SignalResourceRequest(this)
    }
}
