// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * The input for the SetStackPolicy action.
 */
class SetStackPolicyRequest private constructor(builder: Builder) {
    /**
     * The name or unique stack ID that you want to associate a policy with.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent updates
     * to stack resources in the CloudFormation User Guide. You can specify either the
     * StackPolicyBody or the StackPolicyURL parameter, but not
     * both.
     */
    val stackPolicyBody: kotlin.String? = builder.stackPolicyBody
    /**
     * Location of a file containing the stack policy. The URL must point to a policy (maximum
     * size: 16 KB) located in an Amazon S3 bucket in the same Amazon Web Services Region
     * as the stack. You can specify either the StackPolicyBody or the
     * StackPolicyURL parameter, but not both.
     */
    val stackPolicyUrl: kotlin.String? = builder.stackPolicyUrl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetStackPolicyRequest(")
        append("stackName=$stackName,")
        append("stackPolicyBody=$stackPolicyBody,")
        append("stackPolicyUrl=$stackPolicyUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = stackName?.hashCode() ?: 0
        result = 31 * result + (stackPolicyBody?.hashCode() ?: 0)
        result = 31 * result + (stackPolicyUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetStackPolicyRequest

        if (stackName != other.stackName) return false
        if (stackPolicyBody != other.stackPolicyBody) return false
        if (stackPolicyUrl != other.stackPolicyUrl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name or unique stack ID that you want to associate a policy with.
         */
        var stackName: kotlin.String? = null
        /**
         * Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent updates
         * to stack resources in the CloudFormation User Guide. You can specify either the
         * StackPolicyBody or the StackPolicyURL parameter, but not
         * both.
         */
        var stackPolicyBody: kotlin.String? = null
        /**
         * Location of a file containing the stack policy. The URL must point to a policy (maximum
         * size: 16 KB) located in an Amazon S3 bucket in the same Amazon Web Services Region
         * as the stack. You can specify either the StackPolicyBody or the
         * StackPolicyURL parameter, but not both.
         */
        var stackPolicyUrl: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest) : this() {
            this.stackName = x.stackName
            this.stackPolicyBody = x.stackPolicyBody
            this.stackPolicyUrl = x.stackPolicyUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.SetStackPolicyRequest = SetStackPolicyRequest(this)
    }
}
