// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model



/**
 * Structure containing the rollback triggers for CloudFormation to monitor during stack creation
 * and updating operations, and for the specified monitoring period afterwards.
 * Rollback triggers enable you to have CloudFormation monitor the state of your application during
 * stack creation and updating, and to roll back that operation if the application breaches
 * the threshold of any of the alarms you've specified. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html">Monitor and Roll Back Stack
 * Operations.
 */
class RollbackConfiguration private constructor(builder: Builder) {
    /**
     * The amount of time, in minutes, during which CloudFormation should monitor all
     * the rollback triggers after the stack creation or update operation deploys all necessary
     * resources.
     * The default is 0 minutes.
     * If you specify a monitoring period but don't specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old
     * resources after update operations. You can use this monitoring period to perform any manual
     * stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack, for example) as necessary.
     * If you specify 0 for this parameter, CloudFormation still monitors the
     * specified rollback triggers during stack creation and update operations. Then, for update
     * operations, it begins disposing of old resources immediately once the operation
     * completes.
     */
    val monitoringTimeInMinutes: kotlin.Int? = builder.monitoringTimeInMinutes
    /**
     * The triggers to monitor during stack creation or update actions.
     * By default, CloudFormation saves the rollback triggers specified for a stack and applies them to
     * any subsequent update operations for the stack, unless you specify otherwise. If you do
     * specify rollback triggers for this parameter, those triggers replace any list of triggers
     * previously specified for the stack. This means:
     *
     *
     * To use the rollback triggers previously specified for this stack, if any, don't
     * specify this parameter.
     *
     * To specify new or updated rollback triggers, you must specify
     * all the triggers that you want used for this stack, even
     * triggers you've specified before (for example, when creating the stack or during a
     * previous stack update). Any triggers that you don't include in the updated list of
     * triggers are no longer applied to the stack.
     *
     * To remove all currently specified triggers, specify an empty list for this
     * parameter.
     *
     *
     * If a specified trigger is missing, the entire stack operation fails and is rolled
     * back.
     */
    val rollbackTriggers: List<RollbackTrigger>? = builder.rollbackTriggers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RollbackConfiguration(")
        append("monitoringTimeInMinutes=$monitoringTimeInMinutes,")
        append("rollbackTriggers=$rollbackTriggers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = monitoringTimeInMinutes ?: 0
        result = 31 * result + (rollbackTriggers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RollbackConfiguration

        if (monitoringTimeInMinutes != other.monitoringTimeInMinutes) return false
        if (rollbackTriggers != other.rollbackTriggers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The amount of time, in minutes, during which CloudFormation should monitor all
         * the rollback triggers after the stack creation or update operation deploys all necessary
         * resources.
         * The default is 0 minutes.
         * If you specify a monitoring period but don't specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old
         * resources after update operations. You can use this monitoring period to perform any manual
         * stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack, for example) as necessary.
         * If you specify 0 for this parameter, CloudFormation still monitors the
         * specified rollback triggers during stack creation and update operations. Then, for update
         * operations, it begins disposing of old resources immediately once the operation
         * completes.
         */
        var monitoringTimeInMinutes: kotlin.Int? = null
        /**
         * The triggers to monitor during stack creation or update actions.
         * By default, CloudFormation saves the rollback triggers specified for a stack and applies them to
         * any subsequent update operations for the stack, unless you specify otherwise. If you do
         * specify rollback triggers for this parameter, those triggers replace any list of triggers
         * previously specified for the stack. This means:
         *
         *
         * To use the rollback triggers previously specified for this stack, if any, don't
         * specify this parameter.
         *
         * To specify new or updated rollback triggers, you must specify
         * all the triggers that you want used for this stack, even
         * triggers you've specified before (for example, when creating the stack or during a
         * previous stack update). Any triggers that you don't include in the updated list of
         * triggers are no longer applied to the stack.
         *
         * To remove all currently specified triggers, specify an empty list for this
         * parameter.
         *
         *
         * If a specified trigger is missing, the entire stack operation fails and is rolled
         * back.
         */
        var rollbackTriggers: List<RollbackTrigger>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration) : this() {
            this.monitoringTimeInMinutes = x.monitoringTimeInMinutes
            this.rollbackTriggers = x.rollbackTriggers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration = RollbackConfiguration(this)
    }
}
